/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Object getFieldValue(Object instance, Field field) throws IllegalAccessException {
        field.setAccessible(true);
        return field.get(instance);
    }

    public static Field[] getAllFields(Class<?> klass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = klass; c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        Field[] result = new Field[fields.size()];
        return fields.toArray(result);
    }

    public static Method[] getAllMethods(Class<?> klass) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> c = klass; c != null; c = c.getSuperclass()) {
            methods.addAll(Arrays.asList(c.getDeclaredMethods()));
        }
        Method[] result = new Method[methods.size()];
        return methods.toArray(result);
    }

    public static Object[] invokeMethodsWithAnnotation(Object instance, Class<? extends Annotation> annotationClass, Method[] methods) throws Exception {
        Object[] results = new Object[methods.length];
        int i = 0;
        for (Method method : methods) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            results[i] = method.invoke(instance, new Object[0]);
        }
        return results;
    }
}

