/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import java.net.InetAddress;

public class InetAddressConverter
implements Converter<InetAddress> {
    @Override
    public InetAddress convertFrom(String value) {
        InetAddress result;
        try {
            if (null == value) {
                throw new NullPointerException("value must not be null!");
            }
            result = InetAddress.getByName(value);
        }
        catch (Exception ex) {
            throw new ParameterException("Couldn't convert value \"" + value + "\" to InetAddress.", ex);
        }
        return result;
    }

    @Override
    public String convertTo(InetAddress value) {
        if (value == null) {
            throw new ParameterException("Couldn't convert \"null\" to String.");
        }
        return value.getCanonicalHostName();
    }
}

