/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class TimeUnitConverter
implements Converter<TimeUnit> {
    @Override
    public TimeUnit convertFrom(String value) {
        try {
            return TimeUnit.valueOf(value.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception ex) {
            throw new ParameterException("Couldn't convert value \"" + value + "\" to TimeUnit.", ex);
        }
    }

    @Override
    public String convertTo(TimeUnit value) {
        if (value == null) {
            throw new ParameterException("Couldn't convert \"null\" to String.");
        }
        return value.toString();
    }
}

