/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.jodatime.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.Duration;

public class DurationConverter
implements Converter<Duration> {
    private static final Pattern DURATION_PATTERN = Pattern.compile("(\\d+)\\s*(\\w+)");
    private static final Map<String, TimeUnit> SUFFIXES = new HashMap<String, TimeUnit>();

    @Override
    public Duration convertFrom(String value) {
        if (value == null) {
            throw new ParameterException("Couldn't convert \"null\" to Duration object.");
        }
        if (value.startsWith("PT")) {
            return Duration.parse((String)value);
        }
        Matcher matcher = DURATION_PATTERN.matcher(value);
        if (matcher.matches() && matcher.groupCount() >= 2) {
            long longValue = Long.valueOf(matcher.group(1));
            String suffix = matcher.group(2);
            TimeUnit timeUnit = SUFFIXES.get(suffix);
            if (timeUnit == null) {
                throw new ParameterException("Couldn't convert value \"" + value + "\" to Duration object, invalid unit.");
            }
            switch (timeUnit) {
                case DAYS: {
                    return Duration.standardDays((long)longValue);
                }
                case HOURS: {
                    return Duration.standardHours((long)longValue);
                }
                case MINUTES: {
                    return Duration.standardMinutes((long)longValue);
                }
                case SECONDS: {
                    return Duration.standardSeconds((long)longValue);
                }
            }
        }
        throw new ParameterException("Couldn't convert value \"" + value + "\" to Duration object.");
    }

    @Override
    public String convertTo(Duration value) {
        return value.toString();
    }

    static {
        SUFFIXES.put("s", TimeUnit.SECONDS);
        SUFFIXES.put("S", TimeUnit.SECONDS);
        SUFFIXES.put("sec", TimeUnit.SECONDS);
        SUFFIXES.put("secs", TimeUnit.SECONDS);
        SUFFIXES.put("second", TimeUnit.SECONDS);
        SUFFIXES.put("seconds", TimeUnit.SECONDS);
        SUFFIXES.put("m", TimeUnit.MINUTES);
        SUFFIXES.put("M", TimeUnit.MINUTES);
        SUFFIXES.put("min", TimeUnit.MINUTES);
        SUFFIXES.put("minute", TimeUnit.MINUTES);
        SUFFIXES.put("minutes", TimeUnit.MINUTES);
        SUFFIXES.put("h", TimeUnit.HOURS);
        SUFFIXES.put("H", TimeUnit.HOURS);
        SUFFIXES.put("hr", TimeUnit.HOURS);
        SUFFIXES.put("hour", TimeUnit.HOURS);
        SUFFIXES.put("hours", TimeUnit.HOURS);
        SUFFIXES.put("d", TimeUnit.DAYS);
        SUFFIXES.put("D", TimeUnit.DAYS);
        SUFFIXES.put("day", TimeUnit.DAYS);
        SUFFIXES.put("days", TimeUnit.DAYS);
    }
}

