/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.jodatime.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import org.joda.time.Minutes;

public class MinutesConverter
implements Converter<Minutes> {
    @Override
    public Minutes convertFrom(String value) {
        try {
            String trimmed = value.trim();
            if (trimmed.startsWith("P")) {
                return Minutes.parseMinutes((String)trimmed);
            }
            int minutes = Integer.parseInt(trimmed);
            return Minutes.minutes((int)minutes);
        }
        catch (Exception ex) {
            throw new ParameterException("Couldn't convert value \"" + value + "\" to Minutes.", ex);
        }
    }

    @Override
    public String convertTo(Minutes value) {
        if (value == null) {
            throw new ParameterException("Couldn't convert \"null\" to String.");
        }
        return String.valueOf(value.getMinutes());
    }
}

