/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.jodatime.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.Period;

public class PeriodConverter
implements Converter<Period> {
    private static final Pattern PERIOD_PATTERN = Pattern.compile("(\\d+)\\s*(\\w+)");
    private static final Map<String, Boolean> SUFFIXES = new HashMap<String, Boolean>();
    private static final Map<String, Character> NORMALIZED_SUFFIXES = new HashMap<String, Character>();

    @Override
    public Period convertFrom(String value) {
        Period period;
        if (value == null) {
            throw new ParameterException("Couldn't convert \"null\" to Period object.");
        }
        if (value.startsWith("P")) {
            period = Period.parse((String)value);
        } else {
            Matcher matcher = PERIOD_PATTERN.matcher(value);
            if (matcher.matches() && matcher.groupCount() >= 2) {
                Character normalizedSuffix;
                long duration = Long.valueOf(matcher.group(1));
                String suffix = matcher.group(2);
                StringBuilder asIsoFormat = new StringBuilder("P");
                Boolean prefixNecessary = SUFFIXES.get(suffix);
                if (prefixNecessary == null) {
                    throw new ParameterException("Couldn't convert value \"" + value + "\" to Period object, invalid unit.");
                }
                if (prefixNecessary.booleanValue()) {
                    asIsoFormat.append('T');
                }
                if ((normalizedSuffix = NORMALIZED_SUFFIXES.get(suffix)) == null) {
                    throw new ParameterException("Couldn't convert value \"" + value + "\" to Period object, invalid unit.");
                }
                asIsoFormat.append(duration).append(normalizedSuffix);
                period = Period.parse((String)asIsoFormat.toString());
            } else {
                period = null;
            }
        }
        if (period == null) {
            throw new ParameterException("Couldn't convert value \"" + value + "\" to Period object.");
        }
        return period;
    }

    @Override
    public String convertTo(Period value) {
        return value.toString();
    }

    static {
        SUFFIXES.put("s", true);
        SUFFIXES.put("S", true);
        SUFFIXES.put("sec", true);
        SUFFIXES.put("secs", true);
        SUFFIXES.put("second", true);
        SUFFIXES.put("seconds", true);
        SUFFIXES.put("m", true);
        SUFFIXES.put("M", true);
        SUFFIXES.put("min", true);
        SUFFIXES.put("minute", true);
        SUFFIXES.put("minutes", true);
        SUFFIXES.put("h", true);
        SUFFIXES.put("H", true);
        SUFFIXES.put("hr", true);
        SUFFIXES.put("hour", true);
        SUFFIXES.put("hours", true);
        SUFFIXES.put("d", false);
        SUFFIXES.put("D", false);
        SUFFIXES.put("day", false);
        SUFFIXES.put("days", false);
        SUFFIXES.put("w", false);
        SUFFIXES.put("W", false);
        SUFFIXES.put("week", false);
        SUFFIXES.put("weeks", false);
        SUFFIXES.put("month", false);
        SUFFIXES.put("months", false);
        SUFFIXES.put("y", false);
        SUFFIXES.put("Y", false);
        SUFFIXES.put("year", false);
        SUFFIXES.put("years", false);
        NORMALIZED_SUFFIXES.put("s", Character.valueOf('S'));
        NORMALIZED_SUFFIXES.put("S", Character.valueOf('S'));
        NORMALIZED_SUFFIXES.put("sec", Character.valueOf('S'));
        NORMALIZED_SUFFIXES.put("secs", Character.valueOf('S'));
        NORMALIZED_SUFFIXES.put("second", Character.valueOf('S'));
        NORMALIZED_SUFFIXES.put("seconds", Character.valueOf('S'));
        NORMALIZED_SUFFIXES.put("m", Character.valueOf('M'));
        NORMALIZED_SUFFIXES.put("M", Character.valueOf('M'));
        NORMALIZED_SUFFIXES.put("min", Character.valueOf('M'));
        NORMALIZED_SUFFIXES.put("minute", Character.valueOf('M'));
        NORMALIZED_SUFFIXES.put("minutes", Character.valueOf('M'));
        NORMALIZED_SUFFIXES.put("h", Character.valueOf('H'));
        NORMALIZED_SUFFIXES.put("H", Character.valueOf('H'));
        NORMALIZED_SUFFIXES.put("hr", Character.valueOf('H'));
        NORMALIZED_SUFFIXES.put("hour", Character.valueOf('H'));
        NORMALIZED_SUFFIXES.put("hours", Character.valueOf('H'));
        NORMALIZED_SUFFIXES.put("d", Character.valueOf('D'));
        NORMALIZED_SUFFIXES.put("D", Character.valueOf('D'));
        NORMALIZED_SUFFIXES.put("day", Character.valueOf('D'));
        NORMALIZED_SUFFIXES.put("days", Character.valueOf('D'));
        NORMALIZED_SUFFIXES.put("w", Character.valueOf('W'));
        NORMALIZED_SUFFIXES.put("W", Character.valueOf('W'));
        NORMALIZED_SUFFIXES.put("week", Character.valueOf('W'));
        NORMALIZED_SUFFIXES.put("weeks", Character.valueOf('W'));
        NORMALIZED_SUFFIXES.put("month", Character.valueOf('M'));
        NORMALIZED_SUFFIXES.put("months", Character.valueOf('M'));
        NORMALIZED_SUFFIXES.put("y", Character.valueOf('Y'));
        NORMALIZED_SUFFIXES.put("Y", Character.valueOf('Y'));
        NORMALIZED_SUFFIXES.put("year", Character.valueOf('Y'));
        NORMALIZED_SUFFIXES.put("years", Character.valueOf('Y'));
    }
}

