/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.fasterxml.jackson.databind.JsonNode;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.BucketAggregation;
import io.searchbox.core.search.aggregation.HistogramAggregation;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class DateHistogramAggregation
extends BucketAggregation {
    public static final String TYPE = "date_histogram";
    private List<DateHistogram> dateHistograms = new LinkedList<DateHistogram>();

    public DateHistogramAggregation(String name, JsonNode dateHistogramAggregation) {
        super(name, dateHistogramAggregation);
        if (dateHistogramAggregation.has(String.valueOf((Object)AggregationField.BUCKETS)) && dateHistogramAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).isArray()) {
            this.parseBuckets(dateHistogramAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)));
        }
    }

    private void parseBuckets(JsonNode bucketsSource) {
        for (JsonNode bucket : bucketsSource) {
            Long time = bucket.get(String.valueOf((Object)AggregationField.KEY)).asLong();
            String timeAsString = bucket.get(String.valueOf((Object)AggregationField.KEY_AS_STRING)).asText();
            Long count = bucket.get(String.valueOf((Object)AggregationField.DOC_COUNT)).asLong();
            this.dateHistograms.add(new DateHistogram(bucket, time, timeAsString, count));
        }
    }

    public List<DateHistogram> getBuckets() {
        return this.dateHistograms;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DateHistogramAggregation rhs = (DateHistogramAggregation)obj;
        return super.equals(obj) && Objects.equals(this.dateHistograms, rhs.dateHistograms);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dateHistograms);
    }

    public class DateHistogram
    extends HistogramAggregation.Histogram {
        private String timeAsString;

        DateHistogram(JsonNode bucket, Long time, String timeAsString, Long count) {
            super(bucket, time, count);
            this.timeAsString = timeAsString;
        }

        public Long getTime() {
            return this.getKey();
        }

        public String getTimeAsString() {
            return this.timeAsString;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            DateHistogram rhs = (DateHistogram)obj;
            return super.equals(obj) && Objects.equals(this.timeAsString, rhs.timeAsString);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.timeAsString);
        }
    }
}

