/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.fasterxml.jackson.databind.JsonNode;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.MetricAggregation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class PercentilesAggregation
extends MetricAggregation {
    public static final String TYPE = "percentiles";
    private Map<String, Double> percentiles = new HashMap<String, Double>();

    public PercentilesAggregation(String name, JsonNode percentilesAggregation) {
        super(name, percentilesAggregation);
        this.parseSource(percentilesAggregation.get(String.valueOf((Object)AggregationField.VALUES)));
    }

    private void parseSource(JsonNode source) {
        Iterator it = source.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            if (Double.isNaN(((JsonNode)entry.getValue()).asDouble())) continue;
            this.percentiles.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asDouble());
        }
    }

    public Map<String, Double> getPercentiles() {
        return this.percentiles;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PercentilesAggregation rhs = (PercentilesAggregation)obj;
        return super.equals(obj) && Objects.equals(this.percentiles, rhs.percentiles);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.percentiles);
    }
}

