/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.searchbox.client.JestClient;
import io.searchbox.client.config.discovery.NodeChecker;
import io.searchbox.client.config.exception.NoServerConfiguredException;
import io.searchbox.client.config.idle.IdleConnectionReaper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJestClient
implements JestClient {
    public static final String ELASTIC_SEARCH_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    protected ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"));
    private static final Logger log = LoggerFactory.getLogger(AbstractJestClient.class);
    private final AtomicReference<ServerPool> serverPoolReference = new AtomicReference<ServerPool>(new ServerPool((Set<String>)ImmutableSet.of()));
    private NodeChecker nodeChecker;
    private IdleConnectionReaper idleConnectionReaper;
    private boolean requestCompressionEnabled;

    public void setNodeChecker(NodeChecker nodeChecker) {
        this.nodeChecker = nodeChecker;
    }

    public void setIdleConnectionReaper(IdleConnectionReaper idleConnectionReaper) {
        this.idleConnectionReaper = idleConnectionReaper;
    }

    @Override
    public void setServers(Set<String> servers) {
        if (servers.equals(this.serverPoolReference.get().getServers())) {
            if (log.isDebugEnabled()) {
                log.debug("Server pool already contains same list of servers: {}", (Object)Joiner.on((char)',').join(servers));
            }
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("Setting server pool to a list of {} servers: [{}]", (Object)servers.size(), (Object)Joiner.on((char)',').join(servers));
        }
        this.serverPoolReference.set(new ServerPool(servers));
        if (servers.isEmpty()) {
            log.warn("No servers are currently available to connect.");
        }
    }

    @Override
    public void shutdownClient() {
        if (null != this.nodeChecker) {
            this.nodeChecker.stopAsync();
            this.nodeChecker.awaitTerminated();
        }
        if (null != this.idleConnectionReaper) {
            this.idleConnectionReaper.stopAsync();
            this.idleConnectionReaper.awaitTerminated();
        }
    }

    protected String getNextServer() {
        return this.serverPoolReference.get().getNextServer();
    }

    protected int getServerPoolSize() {
        return this.serverPoolReference.get().getSize();
    }

    protected String getRequestURL(String elasticSearchServer, String uri) {
        StringBuilder sb = new StringBuilder(elasticSearchServer);
        if (uri.length() > 0 && uri.charAt(0) == '/') {
            sb.append(uri);
        } else {
            sb.append('/').append(uri);
        }
        return sb.toString();
    }

    public boolean isRequestCompressionEnabled() {
        return this.requestCompressionEnabled;
    }

    public void setRequestCompressionEnabled(boolean requestCompressionEnabled) {
        this.requestCompressionEnabled = requestCompressionEnabled;
    }

    private static final class ServerPool {
        private final List<String> serversRing;
        private final AtomicInteger nextServerIndex = new AtomicInteger(0);

        public ServerPool(Set<String> servers) {
            this.serversRing = ImmutableList.copyOf(servers);
        }

        public Set<String> getServers() {
            return ImmutableSet.copyOf(this.serversRing);
        }

        public String getNextServer() {
            if (this.serversRing.size() > 0) {
                try {
                    return this.serversRing.get(this.nextServerIndex.getAndIncrement() % this.serversRing.size());
                }
                catch (IndexOutOfBoundsException outOfBoundsException) {
                    log.info("Resetting next server index");
                    this.nextServerIndex.set(0);
                    return this.serversRing.get(this.nextServerIndex.getAndIncrement() % this.serversRing.size());
                }
            }
            throw new NoServerConfiguredException("No Server is assigned to client to connect");
        }

        public int getSize() {
            return this.serversRing.size();
        }
    }
}

