/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Sets;
import io.searchbox.client.JestResult;
import io.searchbox.core.search.aggregation.MetricAggregation;
import io.searchbox.core.search.aggregation.RootAggregation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SearchResult
extends JestResult {
    public static final String EXPLANATION_KEY = "_explanation";
    public static final String HIGHLIGHT_KEY = "highlight";
    public static final String SORT_KEY = "sort";
    public static final String[] PATH_TO_TOTAL = "hits/total".split("/");
    public static final String[] PATH_TO_MAX_SCORE = "hits/max_score".split("/");

    public SearchResult(SearchResult searchResult) {
        super(searchResult);
    }

    public SearchResult(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    @Deprecated
    public <T> T getSourceAsObject(Class<T> clazz) {
        return super.getSourceAsObject(clazz);
    }

    @Override
    @Deprecated
    public <T> List<T> getSourceAsObjectList(Class<T> type) {
        return super.getSourceAsObjectList(type);
    }

    public <T> Hit<T, Void> getFirstHit(Class<T> sourceType) {
        return this.getFirstHit(sourceType, Void.class);
    }

    public <T, K> Hit<T, K> getFirstHit(Class<T> sourceType, Class<K> explanationType) {
        Hit<T, K> hit = null;
        List<Hit<T, K>> hits = this.getHits(sourceType, explanationType, true);
        if (!hits.isEmpty()) {
            hit = hits.get(0);
        }
        return hit;
    }

    public <T> List<Hit<T, Void>> getHits(Class<T> sourceType) {
        return this.getHits(sourceType, true);
    }

    public <T> List<Hit<T, Void>> getHits(Class<T> sourceType, boolean addEsMetadataFields) {
        return this.getHits(sourceType, Void.class, addEsMetadataFields);
    }

    public <T, K> List<Hit<T, K>> getHits(Class<T> sourceType, Class<K> explanationType) {
        return this.getHits(sourceType, explanationType, false, true);
    }

    public <T, K> List<Hit<T, K>> getHits(Class<T> sourceType, Class<K> explanationType, boolean addEsMetadataFields) {
        return this.getHits(sourceType, explanationType, false, addEsMetadataFields);
    }

    protected <T, K> List<Hit<T, K>> getHits(Class<T> sourceType, Class<K> explanationType, boolean returnSingle, boolean addEsMetadataFields) {
        String[] keys;
        ArrayList<Hit<T, K>> sourceList = new ArrayList<Hit<T, K>>();
        if (this.jsonObject != null && (keys = this.getKeys()) != null) {
            String sourceKey = keys[keys.length - 1];
            JsonNode obj = this.jsonObject.get(keys[0]);
            for (int i = 1; i < keys.length - 1; ++i) {
                obj = obj.get(keys[i]);
            }
            if (obj.isObject()) {
                sourceList.add(this.extractHit(sourceType, explanationType, obj, sourceKey, addEsMetadataFields));
            } else if (obj.isArray()) {
                for (JsonNode hitElement : obj) {
                    sourceList.add(this.extractHit(sourceType, explanationType, hitElement, sourceKey, addEsMetadataFields));
                    if (!returnSingle) continue;
                    break;
                }
            }
        }
        return sourceList;
    }

    protected <T, K> Hit<T, K> extractHit(Class<T> sourceType, Class<K> explanationType, JsonNode hitElement, String sourceKey, boolean addEsMetadataFields) {
        ObjectNode hitObject;
        ObjectNode source;
        Hit<T, K> hit = null;
        if (hitElement.isObject() && (source = (ObjectNode)(hitObject = (ObjectNode)hitElement).get(sourceKey)) != null) {
            String index = hitObject.get("_index").asText();
            String type = hitObject.get("_type").asText();
            String id = hitObject.get("_id").asText();
            Double score = null;
            if (hitObject.has("_score") && !hitObject.get("_score").isNull()) {
                score = hitObject.get("_score").asDouble();
            }
            JsonNode explanation = hitObject.get(EXPLANATION_KEY);
            Map<String, List<String>> highlight = this.extractHighlight((ObjectNode)hitObject.get(HIGHLIGHT_KEY));
            List<String> sort = this.extractSort(hitObject.get(SORT_KEY));
            if (addEsMetadataFields) {
                ObjectNode clonedSource = null;
                for (JestResult.MetaField metaField : META_FIELDS) {
                    JsonNode metaElement = hitObject.get(metaField.esFieldName);
                    if (metaElement == null) continue;
                    if (clonedSource == null) {
                        clonedSource = source.deepCopy();
                    }
                    clonedSource.set(metaField.internalFieldName, metaElement);
                }
                if (clonedSource != null) {
                    source = clonedSource;
                }
            }
            hit = new Hit<T, K>(sourceType, (JsonNode)source, explanationType, explanation, highlight, sort, index, type, id, score);
        }
        return hit;
    }

    protected List<String> extractSort(JsonNode sort) {
        if (sort == null) {
            return null;
        }
        ArrayList<String> retval = new ArrayList<String>(sort.size());
        for (JsonNode sortValue : sort) {
            retval.add(sortValue.isNull() ? "" : sortValue.asText());
        }
        return retval;
    }

    protected Map<String, List<String>> extractHighlight(ObjectNode highlight) {
        HashMap retval = null;
        if (highlight != null) {
            HashSet highlightSet = Sets.newHashSet((Iterator)highlight.fields());
            retval = new HashMap(highlightSet.size());
            for (Map.Entry entry : highlightSet) {
                ArrayList<String> fragments = new ArrayList<String>();
                for (JsonNode element : (JsonNode)entry.getValue()) {
                    fragments.add(element.asText());
                }
                retval.put(entry.getKey(), fragments);
            }
        }
        return retval;
    }

    public Integer getTotal() {
        Integer total = null;
        JsonNode obj = this.getPath(PATH_TO_TOTAL);
        if (obj != null) {
            total = obj.asInt();
        }
        return total;
    }

    public Float getMaxScore() {
        Float maxScore = null;
        JsonNode obj = this.getPath(PATH_TO_MAX_SCORE);
        if (obj != null) {
            maxScore = Float.valueOf(obj.floatValue());
        }
        return maxScore;
    }

    protected JsonNode getPath(String[] path) {
        JsonNode retval = null;
        if (this.jsonObject != null) {
            JsonNode obj = this.jsonObject;
            for (String component : path) {
                if (obj == null) break;
                obj = ((ObjectNode)obj).get(component);
            }
            retval = obj;
        }
        return retval;
    }

    public MetricAggregation getAggregations() {
        String rootAggrgationName = "aggs";
        if (this.jsonObject == null) {
            return new RootAggregation("aggs", (JsonNode)this.objectMapper.createObjectNode());
        }
        if (this.jsonObject.has("aggregations")) {
            return new RootAggregation("aggs", this.jsonObject.get("aggregations"));
        }
        if (this.jsonObject.has("aggs")) {
            return new RootAggregation("aggs", this.jsonObject.get("aggs"));
        }
        return new RootAggregation("aggs", (JsonNode)this.objectMapper.createObjectNode());
    }

    public class Hit<T, K> {
        public final T source;
        public final K explanation;
        public final Map<String, List<String>> highlight;
        public final List<String> sort;
        public final String index;
        public final String type;
        public final String id;
        public final Double score;

        public Hit(Class<T> sourceType, JsonNode source) {
            this(sourceType, source, (Class<K>)null, (JsonNode)null);
        }

        public Hit(Class<T> sourceType, JsonNode source, Class<K> explanationType, JsonNode explanation) {
            this(sourceType, source, explanationType, explanation, null, null);
        }

        public Hit(Class<T> sourceType, JsonNode source, Class<K> explanationType, JsonNode explanation, Map<String, List<String>> highlight, List<String> sort) {
            this(sourceType, source, explanationType, explanation, highlight, sort, null, null, null, null);
        }

        public Hit(Class<T> sourceType, JsonNode source, Class<K> explanationType, JsonNode explanation, Map<String, List<String>> highlight, List<String> sort, String index, String type, String id, Double score) {
            this.source = source == null ? null : SearchResult.this.createSourceObject(source, sourceType);
            this.explanation = explanation == null ? null : SearchResult.this.createSourceObject(explanation, explanationType);
            this.highlight = highlight;
            this.sort = sort;
            this.index = index;
            this.type = type;
            this.id = id;
            this.score = score;
        }

        public Hit(T source) {
            this(source, null, null, null);
        }

        public Hit(T source, K explanation) {
            this(source, explanation, null, null);
        }

        public Hit(T source, K explanation, Map<String, List<String>> highlight, List<String> sort) {
            this(source, explanation, highlight, sort, null, null, null, null);
        }

        public Hit(T source, K explanation, Map<String, List<String>> highlight, List<String> sort, String index, String type, String id, Double score) {
            this.source = source;
            this.explanation = explanation;
            this.highlight = highlight;
            this.sort = sort;
            this.index = index;
            this.type = type;
            this.id = id;
            this.score = score;
        }

        public int hashCode() {
            return Objects.hash(this.source, this.explanation, this.highlight, this.sort, this.index, this.type, this.id);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Hit rhs = (Hit)obj;
            return Objects.equals(this.source, rhs.source) && Objects.equals(this.explanation, rhs.explanation) && Objects.equals(this.highlight, rhs.highlight) && Objects.equals(this.sort, rhs.sort) && Objects.equals(this.index, rhs.index) && Objects.equals(this.type, rhs.type) && Objects.equals(this.id, rhs.id);
        }
    }
}

