/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.fasterxml.jackson.databind.JsonNode;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.MetricAggregation;
import java.util.Objects;

public class GeoBoundsAggregation
extends MetricAggregation {
    public static final String TYPE = "geo_bounds";
    private Double topLeftLat;
    private Double topLeftLon;
    private Double bottomRightLat;
    private Double bottomRightLon;

    public GeoBoundsAggregation(String name, JsonNode geoBoundsAggregation) {
        super(name, geoBoundsAggregation);
        if (geoBoundsAggregation.has(String.valueOf((Object)AggregationField.BOUNDS))) {
            JsonNode bounds = geoBoundsAggregation.get(String.valueOf((Object)AggregationField.BOUNDS));
            JsonNode topLeft = bounds.get(String.valueOf((Object)AggregationField.TOP_LEFT));
            JsonNode bottomRight = bounds.get(String.valueOf((Object)AggregationField.BOTTOM_RIGHT));
            this.topLeftLat = topLeft.get(String.valueOf((Object)AggregationField.LAT)).asDouble();
            this.topLeftLon = topLeft.get(String.valueOf((Object)AggregationField.LON)).asDouble();
            this.bottomRightLat = bottomRight.get(String.valueOf((Object)AggregationField.LAT)).asDouble();
            this.bottomRightLon = bottomRight.get(String.valueOf((Object)AggregationField.LON)).asDouble();
        }
    }

    public Double getTopLeftLat() {
        return this.topLeftLat;
    }

    public Double getTopLeftLon() {
        return this.topLeftLon;
    }

    public Double getBottomRightLat() {
        return this.bottomRightLat;
    }

    public Double getBottomRightLon() {
        return this.bottomRightLon;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GeoBoundsAggregation rhs = (GeoBoundsAggregation)obj;
        return super.equals(obj) && Objects.equals(this.topLeftLat, rhs.topLeftLat) && Objects.equals(this.topLeftLon, rhs.topLeftLon) && Objects.equals(this.bottomRightLat, rhs.bottomRightLat) && Objects.equals(this.bottomRightLon, rhs.bottomRightLon);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bottomRightLat, this.bottomRightLon, this.topLeftLat, this.topLeftLon);
    }
}

