/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.fasterxml.jackson.databind.JsonNode;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.BucketAggregation;
import io.searchbox.core.search.aggregation.Range;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class GeoDistanceAggregation
extends BucketAggregation {
    public static final String TYPE = "geo_distance";
    private List<Range> geoDistances = new LinkedList<Range>();

    public GeoDistanceAggregation(String name, JsonNode geoDistanceAggregation) {
        super(name, geoDistanceAggregation);
        if (geoDistanceAggregation.has(String.valueOf((Object)AggregationField.BUCKETS)) && geoDistanceAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).isArray()) {
            this.parseBuckets(geoDistanceAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)));
        }
    }

    private void parseBuckets(JsonNode buckets) {
        Iterator iterator = buckets.iterator();
        while (iterator.hasNext()) {
            JsonNode bucket;
            Range geoDistance = new Range(bucket, (bucket = (JsonNode)iterator.next()).has(String.valueOf((Object)AggregationField.FROM)) ? Double.valueOf(bucket.get(String.valueOf((Object)AggregationField.FROM)).asDouble()) : null, bucket.has(String.valueOf((Object)AggregationField.TO)) ? Double.valueOf(bucket.get(String.valueOf((Object)AggregationField.TO)).asDouble()) : null, bucket.has(String.valueOf((Object)AggregationField.DOC_COUNT)) ? Long.valueOf(bucket.get(String.valueOf((Object)AggregationField.DOC_COUNT)).asLong()) : null);
            this.geoDistances.add(geoDistance);
        }
    }

    public List<Range> getBuckets() {
        return this.geoDistances;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GeoDistanceAggregation rhs = (GeoDistanceAggregation)obj;
        return super.equals(obj) && Objects.equals(this.geoDistances, rhs.geoDistances);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.geoDistances);
    }
}

