/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.usagestatistics.collectors;

import com.github.joschi.jadconfig.util.Duration;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.cliffc.high_scale_lib.Counter;
import org.graylog.plugins.usagestatistics.UsageStatsMetaData;
import org.graylog.plugins.usagestatistics.collectors.CollectorCollector;
import org.graylog.plugins.usagestatistics.collectors.ElasticsearchCollector;
import org.graylog.plugins.usagestatistics.collectors.MongoCollector;
import org.graylog.plugins.usagestatistics.dto.ClusterDataSet;
import org.graylog.plugins.usagestatistics.dto.ClusterStats;
import org.graylog2.indexer.counts.Counts;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.cluster.ClusterId;
import org.graylog2.plugin.inputs.Extractor;
import org.graylog2.shared.stats.ThroughputStats;
import org.graylog2.system.stats.ClusterStatsService;

public class ClusterCollector {
    private final ClusterStatsService clusterStatsService;
    private final ElasticsearchCollector elasticsearchCollector;
    private final MongoCollector mongoCollector;
    private final CollectorCollector collectorCollector;
    private final Counts counts;
    private final ThroughputStats throughputStats;
    private final ClusterConfigService clusterConfigService;
    private final long reportIntervalMs;

    @Inject
    public ClusterCollector(ClusterStatsService clusterStatsService, ElasticsearchCollector elasticsearchCollector, MongoCollector mongoCollector, CollectorCollector collectorCollector, Counts counts, ThroughputStats throughputStats, @Named(value="usage_statistics_report_interval") Duration reportInterval, ClusterConfigService clusterConfigService) {
        this.clusterStatsService = (ClusterStatsService)Preconditions.checkNotNull((Object)clusterStatsService);
        this.elasticsearchCollector = (ElasticsearchCollector)Preconditions.checkNotNull((Object)elasticsearchCollector);
        this.mongoCollector = (MongoCollector)Preconditions.checkNotNull((Object)mongoCollector);
        this.collectorCollector = (CollectorCollector)Preconditions.checkNotNull((Object)collectorCollector);
        this.counts = (Counts)Preconditions.checkNotNull((Object)counts);
        this.throughputStats = (ThroughputStats)Preconditions.checkNotNull((Object)throughputStats);
        this.reportIntervalMs = ((Duration)Preconditions.checkNotNull((Object)reportInterval)).toMilliseconds();
        this.clusterConfigService = (ClusterConfigService)Preconditions.checkNotNull((Object)clusterConfigService);
    }

    public ClusterDataSet getClusterDataSet() {
        ClusterId clusterId = (ClusterId)this.clusterConfigService.getOrDefault(ClusterId.class, (Object)ClusterId.create((String)""));
        return ClusterDataSet.create(String.valueOf(UsageStatsMetaData.VERSION), clusterId.clusterId(), System.currentTimeMillis(), this.reportIntervalMs, this.buildClusterStats());
    }

    private ClusterStats buildClusterStats() {
        return ClusterStats.create(this.elasticsearchCollector.getClusterStats(), this.elasticsearchCollector.getNodeInfos(), this.mongoCollector.getMongoStats(), this.collectorCollector.getCollectorInfos(), this.clusterStatsService.clusterStats().streamCount(), this.clusterStatsService.clusterStats().streamRuleCount(), this.clusterStatsService.clusterStats().streamRuleCountByStream(), this.clusterStatsService.clusterStats().userCount(), this.clusterStatsService.clusterStats().outputCount(), this.clusterStatsService.clusterStats().outputCountByType(), this.clusterStatsService.clusterStats().dashboardCount(), this.clusterStatsService.clusterStats().inputCount(), this.clusterStatsService.clusterStats().globalInputCount(), this.clusterStatsService.clusterStats().inputCountByType(), this.clusterStatsService.clusterStats().extractorCount(), this.buildExtractorCountByType(), this.clusterStatsService.clusterStats().contentPackCount(), this.counts.total(), this.buildStreamThroughput());
    }

    private Map<String, Long> buildStreamThroughput() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.throughputStats.getCurrentStreamThroughput().entrySet()) {
            builder.put(entry.getKey(), (Object)((Counter)entry.getValue()).get());
        }
        return builder.build();
    }

    private Map<String, Long> buildExtractorCountByType() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.clusterStatsService.clusterStats().extractorCountByType().entrySet()) {
            builder.put((Object)((Extractor.Type)entry.getKey()).name(), entry.getValue());
        }
        return builder.build();
    }
}

