/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.usagestatistics.collectors;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.monitor.jvm.JvmStats;
import org.graylog.plugins.usagestatistics.dto.HostInfo;
import org.graylog.plugins.usagestatistics.dto.JvmInfo;
import org.graylog.plugins.usagestatistics.dto.MacAddress;
import org.graylog.plugins.usagestatistics.dto.elasticsearch.ClusterHealth;
import org.graylog.plugins.usagestatistics.dto.elasticsearch.ElasticsearchClusterStats;
import org.graylog.plugins.usagestatistics.dto.elasticsearch.ElasticsearchNodeInfo;
import org.graylog.plugins.usagestatistics.dto.elasticsearch.IndicesStats;
import org.graylog.plugins.usagestatistics.dto.elasticsearch.NodesStats;
import org.graylog2.system.stats.ClusterStatsService;
import org.graylog2.system.stats.elasticsearch.ElasticsearchStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchCollector {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchCollector.class);
    private final Client client;
    private final ClusterStatsService clusterStatsService;

    @Inject
    public ElasticsearchCollector(Client client, ClusterStatsService clusterStatsService) {
        this.client = client;
        this.clusterStatsService = clusterStatsService;
    }

    public Set<ElasticsearchNodeInfo> getNodeInfos() {
        Map<String, NodeInfo> nodeInfos = this.fetchNodeInfos();
        Map<String, NodeStats> nodeStats = this.fetchNodeStats();
        HashSet elasticsearchNodeInfos = Sets.newHashSetWithExpectedSize((int)nodeInfos.size());
        for (String node : nodeInfos.keySet()) {
            JvmInfo jvmInfo;
            List<Object> garbageCollectors;
            NodeInfo info = nodeInfos.get(node);
            NodeStats stats = nodeStats.get(node);
            if (info == null || stats == null) {
                LOG.warn("Couldn't retrieve all required information from Elasticsearch node {}, skipping.", (Object)node);
                continue;
            }
            MacAddress macAddress = info.getNetwork() == null ? MacAddress.EMPTY : MacAddress.create(info.getNetwork().primaryInterface().macAddress());
            HostInfo.Cpu cpu = info.getOs().cpu() == null ? null : HostInfo.Cpu.create(info.getOs().cpu().model(), info.getOs().cpu().vendor(), info.getOs().cpu().mhz(), info.getOs().cpu().totalCores(), info.getOs().cpu().totalSockets(), info.getOs().cpu().coresPerSocket(), info.getOs().cpu().cacheSize().bytes());
            HostInfo.Memory memory = info.getOs().mem() == null ? null : HostInfo.Memory.create(info.getOs().mem().total().bytes());
            HostInfo.Memory swap = info.getOs().swap() == null ? null : HostInfo.Memory.create(info.getOs().swap().total().bytes());
            HostInfo hostInfo = HostInfo.create(macAddress, cpu, memory, swap);
            if (stats.getJvm() != null) {
                garbageCollectors = Lists.newArrayList();
                for (JvmStats.GarbageCollector gc : stats.getJvm().gc()) {
                    garbageCollectors.add(gc.name());
                }
            } else {
                garbageCollectors = Collections.emptyList();
            }
            if (info.getJvm() != null) {
                JvmInfo.Memory jvmMemory = JvmInfo.Memory.create(info.getJvm().mem().heapInit().bytes(), info.getJvm().mem().heapMax().bytes(), info.getJvm().mem().nonHeapInit().bytes(), info.getJvm().mem().nonHeapMax().bytes(), info.getJvm().mem().directMemoryMax().bytes());
                JvmInfo.Os jvmOs = JvmInfo.Os.create((String)info.getJvm().getSystemProperties().get("os.name"), (String)info.getJvm().getSystemProperties().get("os.version"), (String)info.getJvm().getSystemProperties().get("os.arch"));
                jvmInfo = JvmInfo.create(info.getJvm().version(), info.getJvm().vmName(), info.getJvm().vmVersion(), info.getJvm().vmVendor(), jvmOs, jvmMemory, garbageCollectors);
            } else {
                jvmInfo = null;
            }
            ElasticsearchNodeInfo elasticsearchNodeInfo = ElasticsearchNodeInfo.create(info.getVersion().toString(), hostInfo, jvmInfo);
            elasticsearchNodeInfos.add(elasticsearchNodeInfo);
        }
        return elasticsearchNodeInfos;
    }

    public ElasticsearchClusterStats getClusterStats() {
        ElasticsearchStats stats = this.clusterStatsService.elasticsearchStats();
        return ElasticsearchClusterStats.create(ClusterHealth.fromClusterHealth(stats.clusterHealth()), NodesStats.fromNodesStats(stats.nodesStats()), IndicesStats.fromIndicesStats(stats.indicesStats()));
    }

    private Map<String, NodeInfo> fetchNodeInfos() {
        ClusterAdminClient adminClient = this.client.admin().cluster();
        NodesInfoResponse nodesInfoResponse = (NodesInfoResponse)adminClient.nodesInfo((NodesInfoRequest)adminClient.prepareNodesInfo(new String[0]).request()).actionGet();
        return nodesInfoResponse.getNodesMap();
    }

    private Map<String, NodeStats> fetchNodeStats() {
        ClusterAdminClient adminClient = this.client.admin().cluster();
        NodesStatsResponse nodesStatsResponse = (NodesStatsResponse)adminClient.nodesStats((NodesStatsRequest)adminClient.prepareNodesStats(new String[0]).request()).actionGet();
        return nodesStatsResponse.getNodesMap();
    }
}

