/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.usagestatistics.collectors;

import com.codahale.metrics.MetricRegistry;
import com.github.joschi.jadconfig.util.Duration;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.SystemUtils;
import org.graylog.plugins.usagestatistics.UsageStatsMetaData;
import org.graylog.plugins.usagestatistics.dto.BufferStats;
import org.graylog.plugins.usagestatistics.dto.Histogram;
import org.graylog.plugins.usagestatistics.dto.HostInfo;
import org.graylog.plugins.usagestatistics.dto.HostStats;
import org.graylog.plugins.usagestatistics.dto.JournalStats;
import org.graylog.plugins.usagestatistics.dto.JvmInfo;
import org.graylog.plugins.usagestatistics.dto.MacAddress;
import org.graylog.plugins.usagestatistics.dto.NodeDataSet;
import org.graylog.plugins.usagestatistics.dto.NodeInfo;
import org.graylog.plugins.usagestatistics.dto.NodeRole;
import org.graylog.plugins.usagestatistics.dto.NodeStats;
import org.graylog.plugins.usagestatistics.dto.Os;
import org.graylog.plugins.usagestatistics.dto.PluginInfo;
import org.graylog.plugins.usagestatistics.dto.ThroughputStats;
import org.graylog.plugins.usagestatistics.shaded.OS;
import org.graylog.plugins.usagestatistics.util.MetricUtils;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Version;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.cluster.ClusterId;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.system.stats.StatsService;
import org.graylog2.shared.system.stats.jvm.JvmStats;
import org.graylog2.shared.system.stats.network.NetworkStats;
import org.graylog2.shared.system.stats.os.OsStats;

@Singleton
public class NodeCollector {
    private static final long JVM_START = System.nanoTime();
    private final NodeId nodeId;
    private final ServerStatus serverStatus;
    private final MetricRegistry metricRegistry;
    private final StatsService statsService;
    private final InputService inputService;
    private final ClusterConfigService clusterConfigService;
    private final Set<PluginMetaData> plugins;
    private final long reportIntervalMs;

    @Inject
    public NodeCollector(NodeId nodeId, ServerStatus serverStatus, MetricRegistry metricRegistry, StatsService statsService, InputService inputService, ClusterConfigService clusterConfigService, Set<PluginMetaData> plugins, @Named(value="usage_statistics_report_interval") Duration reportInterval) {
        this.nodeId = (NodeId)Preconditions.checkNotNull((Object)nodeId);
        this.serverStatus = (ServerStatus)Preconditions.checkNotNull((Object)serverStatus);
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry);
        this.statsService = (StatsService)Preconditions.checkNotNull((Object)statsService);
        this.inputService = (InputService)Preconditions.checkNotNull((Object)inputService);
        this.clusterConfigService = (ClusterConfigService)Preconditions.checkNotNull((Object)clusterConfigService);
        this.plugins = (Set)Preconditions.checkNotNull(plugins);
        this.reportIntervalMs = ((Duration)Preconditions.checkNotNull((Object)reportInterval)).toMilliseconds();
    }

    public NodeDataSet getNodeDataSet() {
        ClusterId clusterId = (ClusterId)this.clusterConfigService.getOrDefault(ClusterId.class, (Object)ClusterId.create((String)""));
        return NodeDataSet.create(String.valueOf(UsageStatsMetaData.VERSION), clusterId.clusterId(), this.nodeId.anonymize(), System.currentTimeMillis(), this.reportIntervalMs, this.buildNodeInfo(), this.buildNodeStats(), this.buildHostInfo(), this.buildHostStats(), this.buildJvmSpecs());
    }

    private NodeInfo buildNodeInfo() {
        return NodeInfo.create(NodeRole.fromCapabilities(this.serverStatus), Version.CURRENT_CLASSPATH.toString(), this.buildPluginInfo(this.plugins), this.buildOsInfo());
    }

    private Os buildOsInfo() {
        OS os = OS.getOs();
        return Os.create(os.getName(), os.getVersion(), os.getArch(), os.getPlatformName());
    }

    private Set<PluginInfo> buildPluginInfo(Set<PluginMetaData> plugins) {
        HashSet pluginInfos = Sets.newHashSetWithExpectedSize((int)plugins.size());
        for (PluginMetaData pluginMetaData : plugins) {
            pluginInfos.add(PluginInfo.create(pluginMetaData.getUniqueId(), pluginMetaData.getName(), pluginMetaData.getVersion().toString()));
        }
        return pluginInfos;
    }

    private HostInfo buildHostInfo() {
        MacAddress macAddress = this.findMacAddress();
        OsStats osStats = this.statsService.osStats();
        HostInfo.Cpu cpu = HostInfo.Cpu.create(osStats.processor().model(), osStats.processor().vendor(), osStats.processor().mhz(), osStats.processor().totalCores(), osStats.processor().totalSockets(), osStats.processor().coresPerSocket(), osStats.processor().cacheSize());
        HostInfo.Memory memory = HostInfo.Memory.create(osStats.memory().total());
        HostInfo.Memory swap = HostInfo.Memory.create(osStats.swap().total());
        return HostInfo.create(macAddress, cpu, memory, swap);
    }

    private MacAddress findMacAddress() {
        NetworkStats networkStats = this.statsService.networkStats();
        NetworkStats.Interface networkInterface = (NetworkStats.Interface)networkStats.interfaces().get(networkStats.primaryInterface());
        MacAddress macAddress = networkInterface == null || Strings.isNullOrEmpty((String)networkInterface.macAddress()) ? MacAddress.EMPTY : MacAddress.create(networkInterface.macAddress());
        return macAddress;
    }

    private JvmInfo buildJvmSpecs() {
        JvmStats jvmStats = this.statsService.jvmStats();
        JvmInfo.Os os = JvmInfo.Os.create(SystemUtils.OS_NAME, SystemUtils.OS_VERSION, SystemUtils.OS_ARCH);
        JvmInfo.Memory jvmMemory = JvmInfo.Memory.create(jvmStats.mem().heapInit(), jvmStats.mem().heapMax(), jvmStats.mem().nonHeapInit(), jvmStats.mem().nonHeapMax(), jvmStats.mem().directMemoryMax());
        return JvmInfo.create(jvmStats.version(), jvmStats.vmName(), jvmStats.vmVersion(), jvmStats.vmVendor(), os, jvmMemory, jvmStats.garbageCollectors());
    }

    private NodeStats buildNodeStats() {
        long uptime = (System.nanoTime() - JVM_START) / 1000000L;
        ThroughputStats throughputStats = ThroughputStats.create(ThroughputStats.Throughput.create(MetricUtils.safeGetCounter(this.metricRegistry, "org.graylog2.throughput.input").getCount(), (Double)MetricUtils.safeGetDoubleGauge(this.metricRegistry, "org.graylog2.throughput.input.1-sec-rate").getValue()), ThroughputStats.Throughput.create(MetricUtils.safeGetCounter(this.metricRegistry, "org.graylog2.throughput.output").getCount(), (Double)MetricUtils.safeGetDoubleGauge(this.metricRegistry, "org.graylog2.throughput.output.1-sec-rate").getValue()));
        BufferStats bufferStats = BufferStats.create(BufferStats.Buffer.create((Long)MetricUtils.safeGetLongGauge(this.metricRegistry, "org.graylog2.buffers.input.size").getValue(), (Long)MetricUtils.safeGetLongGauge(this.metricRegistry, "org.graylog2.buffers.input.usage").getValue()), BufferStats.Buffer.create((Long)MetricUtils.safeGetLongGauge(this.metricRegistry, "org.graylog2.buffers.process.size").getValue(), (Long)MetricUtils.safeGetLongGauge(this.metricRegistry, "org.graylog2.buffers.process.usage").getValue()), BufferStats.Buffer.create((Long)MetricUtils.safeGetLongGauge(this.metricRegistry, "org.graylog2.buffers.output.size").getValue(), (Long)MetricUtils.safeGetLongGauge(this.metricRegistry, "org.graylog2.buffers.output.usage").getValue()));
        JournalStats journalStats = JournalStats.create((Long)MetricUtils.safeGetLongGauge(this.metricRegistry, "org.graylog2.journal.size").getValue(), (Long)MetricUtils.safeGetLongGauge(this.metricRegistry, "org.graylog2.journal.size-limit").getValue(), ((Integer)MetricUtils.safeGetIntegerGauge(this.metricRegistry, "org.graylog2.journal.segments").getValue()).intValue(), (Long)MetricUtils.safeGetLongGauge(this.metricRegistry, "org.graylog2.journal.entries-uncommitted").getValue(), MetricUtils.safeGetMeter(this.metricRegistry, "org.graylog2.shared.journal.KafkaJournal.readMessages").getCount(), MetricUtils.safeGetMeter(this.metricRegistry, "org.graylog2.shared.journal.KafkaJournal.writtenMessages").getCount());
        Histogram searchTimings = Histogram.fromMetricsTimer(MetricUtils.safeGetTimer(this.metricRegistry, "org.graylog2.indexer.searches.Searches.elasticsearch.requests"));
        Histogram searchRanges = Histogram.fromMetricsHistogram(MetricUtils.safeGetHistogram(this.metricRegistry, "org.graylog2.indexer.searches.Searches.elasticsearch.ranges"));
        return NodeStats.create(uptime, this.inputService.totalCountForNode(this.nodeId.toString()), throughputStats, bufferStats, journalStats, searchTimings, searchRanges);
    }

    private HostStats buildHostStats() {
        OsStats osStats = this.statsService.osStats();
        HostStats.Memory memory = osStats.memory() == null ? null : HostStats.Memory.create(osStats.memory().free(), osStats.memory().used());
        HostStats.Memory swap = osStats.swap() == null ? null : HostStats.Memory.create(osStats.swap().free(), osStats.swap().used());
        return HostStats.create(osStats.loadAverage(), memory, swap);
    }
}

