/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.usagestatistics;

import com.github.joschi.jadconfig.util.Duration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.graylog.plugins.usagestatistics.collectors.NodeCollector;
import org.graylog.plugins.usagestatistics.dto.NodeDataSet;

@Singleton
public class UsageStatsNodeService {
    private final Supplier<NodeDataSet> cachedDataSet;

    @Inject
    public UsageStatsNodeService(NodeCollector nodeCollector, @Named(value="usage_statistics_cache_timeout") Duration cacheTimeout) {
        this(UsageStatsNodeService.supplier(nodeCollector), cacheTimeout);
    }

    @VisibleForTesting
    UsageStatsNodeService(Supplier<NodeDataSet> nodeDataSetSupplier, Duration cacheTimeout) {
        this.cachedDataSet = Suppliers.memoizeWithExpiration(nodeDataSetSupplier, (long)cacheTimeout.getQuantity(), (TimeUnit)cacheTimeout.getUnit());
    }

    private static Supplier<NodeDataSet> supplier(final NodeCollector nodeCollector) {
        return new Supplier<NodeDataSet>(){

            public NodeDataSet get() {
                return nodeCollector.getNodeDataSet();
            }
        };
    }

    public NodeDataSet buildNodeDataSet() {
        return (NodeDataSet)this.cachedDataSet.get();
    }
}

