/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.usagestatistics;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.usagestatistics.UsageStatsClusterService;
import org.graylog.plugins.usagestatistics.UsageStatsConfiguration;
import org.graylog.plugins.usagestatistics.UsageStatsConfigurationResponse;
import org.graylog.plugins.usagestatistics.UsageStatsNodeService;
import org.graylog.plugins.usagestatistics.dto.ClusterDataSet;
import org.graylog.plugins.usagestatistics.dto.NodeDataSet;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="UsageStatistics", description="Anonymous usage statistics of this Graylog setup")
@Path(value="/")
public class UsageStatsResource
extends RestResource
implements PluginRestResource {
    private final UsageStatsNodeService usageStatsNodeService;
    private final UsageStatsClusterService usageStatsClusterService;
    private final UsageStatsConfiguration configuration;

    @Inject
    public UsageStatsResource(UsageStatsNodeService usageStatsNodeService, UsageStatsClusterService usageStatsClusterService, UsageStatsConfiguration configuration) {
        this.usageStatsNodeService = usageStatsNodeService;
        this.usageStatsClusterService = usageStatsClusterService;
        this.configuration = configuration;
    }

    @GET
    @Path(value="config")
    @Timed
    @ApiOperation(value="Show configuration for the anonymous usage statistics plugin")
    @Produces(value={"application/json"})
    public UsageStatsConfigurationResponse showConfig() {
        return UsageStatsConfigurationResponse.create(this.configuration.isEnabled());
    }

    @GET
    @Path(value="node")
    @Timed
    @ApiOperation(value="Show the collected anonymous usage statistics of this Graylog node")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=500, message="Internal Server Error")})
    public NodeDataSet showNodeDataSet() {
        return this.usageStatsNodeService.buildNodeDataSet();
    }

    @GET
    @Path(value="cluster")
    @Timed
    @ApiOperation(value="Show the collected anonymous usage statistics of this Graylog cluster")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=500, message="Internal Server Error")})
    public ClusterDataSet showClusterDataSet() {
        return this.usageStatsClusterService.buildClusterDataSet();
    }
}

