/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.usagestatistics.collectors;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.graylog.plugins.usagestatistics.dto.MongoDatabaseStats;
import org.graylog2.system.stats.ClusterStatsService;
import org.graylog2.system.stats.mongo.DatabaseStats;
import org.graylog2.system.stats.mongo.HostInfo;
import org.graylog2.system.stats.mongo.MongoStats;

public class MongoCollector {
    private final ClusterStatsService clusterStatsService;

    @Inject
    public MongoCollector(ClusterStatsService clusterStatsService) {
        this.clusterStatsService = (ClusterStatsService)Preconditions.checkNotNull((Object)clusterStatsService);
    }

    public org.graylog.plugins.usagestatistics.dto.MongoStats getMongoStats() {
        MongoStats stats = this.clusterStatsService.mongoStats();
        DatabaseStats databaseStats = stats.databaseStats();
        MongoDatabaseStats mongoDatabaseStats = databaseStats != null ? MongoDatabaseStats.create(databaseStats.collections(), databaseStats.objects(), databaseStats.avgObjSize(), databaseStats.dataSize(), databaseStats.storageSize(), databaseStats.numExtents(), databaseStats.indexes(), databaseStats.indexSize(), databaseStats.fileSize(), databaseStats.nsSizeMB()) : null;
        HostInfo hostInfo = stats.hostInfo();
        return org.graylog.plugins.usagestatistics.dto.MongoStats.create(stats.buildInfo().version(), stats.servers().size(), hostInfo == null || hostInfo.system() == null ? "unknown" : hostInfo.system().cpuArch(), mongoDatabaseStats);
    }
}

