/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal;

import com.googlecode.download.maven.plugin.internal.ProgressReport;
import java.io.File;
import java.net.URI;
import org.apache.maven.plugin.logging.Log;

public final class LoggingProgressReport
implements ProgressReport {
    private static final long KBYTE = 1024L;
    private static final char K_UNIT = 'K';
    private static final char B_UNIT = 'b';
    private final Log log;
    private final File outputFile;
    private char unit;
    private long total;
    private long completed;

    public LoggingProgressReport(Log log, File outputFile) {
        this.log = log;
        this.outputFile = outputFile;
    }

    @Override
    public void initiate(URI uri, long total) {
        this.total = total;
        this.completed = 0L;
        this.unit = (char)(total >= 1024L ? 75 : 98);
        this.log.info((CharSequence)String.format("%s: %s to %s", "Downloading", uri, this.outputFile.getAbsolutePath()));
    }

    @Override
    public void update(long bytesRead) {
        long completedInUnits;
        String totalInUnits;
        this.completed += bytesRead;
        if (this.unit == 'K') {
            totalInUnits = this.total == -1L ? "?" : Long.toString(this.total / 1024L) + this.unit;
            completedInUnits = this.completed / 1024L;
        } else {
            totalInUnits = this.total == -1L ? "?" : Long.toString(this.total);
            completedInUnits = this.completed;
        }
        this.log.debug((CharSequence)String.format("%d/%s", completedInUnits, totalInUnits));
    }

    @Override
    public void completed() {
        this.log.info((CharSequence)String.format("%s %s", "downloaded", this.unit == 'K' ? Long.toString(this.completed / 1024L) + this.unit : Long.toString(this.completed)));
    }

    @Override
    public void error(Exception ex) {
        this.log.error((Throwable)ex);
    }
}

