/*
 * Decompiled with CFR 0.152.
 */
package org.jsoftbiz.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OS {
    private OsInfo osInfo;
    private static final Map<Double, String> macOs = new HashMap<Double, String>();
    private static final Map<Integer, String> darwin = new HashMap<Integer, String>();
    private static final List<String> linux = new ArrayList<String>();

    public OS() {
    }

    private OS(String name, String version, String arch) {
        if (name != null) {
            if (name.startsWith("Windows")) {
                this.osInfo = new OsInfo(name, version, arch, name);
            } else if (name.startsWith("Mac")) {
                this.initMacOsInfo(name, version, arch);
            } else if (name.startsWith("Darwin")) {
                this.initDarwinOsInfo(name, version, arch);
            } else {
                for (String linuxName : linux) {
                    if (!name.startsWith(linuxName)) continue;
                    this.initLinuxOsInfo(name, version, arch);
                }
            }
        }
        if (this.osInfo == null) {
            this.osInfo = new OsInfo(name, version, arch, name);
        }
    }

    public static OS getOs() {
        return SingletonHolder.instance;
    }

    public String getName() {
        return this.osInfo.getName();
    }

    public String getArch() {
        return this.osInfo.getArch();
    }

    public String getVersion() {
        return this.osInfo.getVersion();
    }

    public String getPlatformName() {
        return this.osInfo.getPlatformName();
    }

    private void initMacOsInfo(String name, String version, String arch) {
        String[] versions = version.split("\\.");
        double numericVersion = Double.parseDouble(versions[0] + "." + versions[1]);
        this.osInfo = numericVersion < 10.0 ? new OsInfo(name, version, arch, "Mac OS " + version) : new OsInfo(name, version, arch, "OS X " + macOs.get(numericVersion) + " (" + version + ")");
    }

    private void initDarwinOsInfo(String name, String version, String arch) {
        String[] versions = version.split("\\.");
        int numericVersion = Integer.parseInt(versions[0]);
        this.osInfo = new OsInfo(name, version, arch, "OS X " + darwin.get(numericVersion) + " (" + version + ")");
    }

    private void initLinuxOsInfo(String name, String version, String arch) {
        File fileVersion;
        File dir;
        OsInfo osInfo = this.getPlatformNameFromLsbRelease(name, version, arch);
        if (osInfo == null) {
            osInfo = this.getPlatformNameFromOsRelease(name, version, arch);
        }
        if (osInfo == null) {
            osInfo = this.getPlatformNameFromFile(name, version, arch, "/etc/system-release");
        }
        if ((dir = new File("/etc/")).exists()) {
            if (osInfo == null) {
                osInfo = this.getPlatformNameFromFile(name, version, arch, this.getFileEndingWith(dir, "-release"));
            }
            if (osInfo == null) {
                osInfo = this.getPlatformNameFromFile(name, version, arch, this.getFileEndingWith(dir, "_version"));
            }
            if (osInfo == null) {
                osInfo = this.getPlatformNameFromFile(name, version, arch, "/etc/issue");
            }
        }
        if ((fileVersion = new File("/proc/version")).exists() && osInfo == null) {
            osInfo = this.getPlatformNameFromFile(name, version, arch, fileVersion.getAbsolutePath());
        }
        if (osInfo == null) {
            osInfo = new OsInfo(name, version, arch, name);
        }
        this.osInfo = osInfo;
    }

    private String getFileEndingWith(File dir, final String fileEndingWith) {
        File[] fileList = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(fileEndingWith);
            }
        });
        if (fileList.length > 0) {
            return fileList[0].getAbsolutePath();
        }
        return null;
    }

    private OsInfo getPlatformNameFromFile(String name, String version, String arch, String filename) {
        if (filename == null) {
            return null;
        }
        File f = new File(filename);
        if (f.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(filename));
                return this.readPlatformName(name, version, arch, br);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    OsInfo readPlatformName(String name, String version, String arch, BufferedReader br) throws IOException {
        String line;
        String lineToReturn = null;
        int lineNb = 0;
        while ((line = br.readLine()) != null) {
            if (lineNb++ == 0) {
                lineToReturn = line;
            }
            if (!line.startsWith("PRETTY_NAME")) continue;
            return new OsInfo(name, version, arch, line.substring(13, line.length() - 1));
        }
        return new OsInfo(name, version, arch, lineToReturn);
    }

    private OsInfo getPlatformNameFromOsRelease(String name, String version, String arch) {
        String fileName = "/etc/os-release";
        File f = new File(fileName);
        if (f.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(fileName));
                OsInfo osInfo = this.readPlatformNameFromOsRelease(name, version, arch, br);
                if (osInfo == null) {
                    return this.readPlatformNameFromOsReleaseForArchLinux(name, version, arch, br);
                }
                return osInfo;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    OsInfo readPlatformNameFromOsReleaseForArchLinux(String name, String version, String arch, BufferedReader br) throws IOException {
        String line;
        String distribDescription = "Linux";
        String distribId = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("DISTRIB_DESCRIPTION=")) {
                distribDescription = line.replace("DISTRIB_DESCRIPTION=", "").replace("\"", "");
            }
            if (!line.startsWith("DISTRIB_ID=")) continue;
            distribId = line.replace("DISTRIB_ID=", "").replace("\"", "");
        }
        if (distribDescription != null && distribId != null) {
            return new OsInfo(name, version, arch, distribDescription + " (" + distribId + ")");
        }
        return null;
    }

    OsInfo readPlatformNameFromOsRelease(String name, String version, String arch, BufferedReader br) throws IOException {
        String line;
        String distribName = "Linux";
        String distribVersion = "";
        String distribId = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("NAME=")) {
                distribName = line.replace("NAME=", "").replace("\"", "");
            }
            if (line.startsWith("VERSION=")) {
                distribVersion = line.replace("VERSION=", "").replace("\"", "") + " ";
            }
            if (!line.startsWith("ID=")) continue;
            distribId = line.replace("ID=", "").replace("\"", "");
        }
        if (distribName != null && distribId != null) {
            return new OsInfo(name, version, arch, distribName + " " + distribVersion + "(" + distribId + ")");
        }
        return null;
    }

    private OsInfo getPlatformNameFromLsbRelease(String name, String version, String arch) {
        String fileName = "/etc/lsb-release";
        File f = new File(fileName);
        if (f.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(fileName));
                return this.readPlatformNameFromLsb(name, version, arch, br);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    OsInfo readPlatformNameFromLsb(String name, String version, String arch, BufferedReader br) throws IOException {
        String line;
        String distribDescription = null;
        String distribCodename = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("DISTRIB_DESCRIPTION")) {
                distribDescription = line.replace("DISTRIB_DESCRIPTION=", "").replace("\"", "");
            }
            if (!line.startsWith("DISTRIB_CODENAME")) continue;
            distribCodename = line.replace("DISTRIB_CODENAME=", "");
        }
        if (distribDescription != null && distribCodename != null) {
            return new OsInfo(name, version, arch, distribDescription + " (" + distribCodename + ")");
        }
        return null;
    }

    static {
        macOs.put(10.0, "Puma");
        macOs.put(10.1, "Cheetah");
        macOs.put(10.2, "Jaguar");
        macOs.put(10.3, "Panther");
        macOs.put(10.4, "Tiger");
        macOs.put(10.5, "Leopard");
        macOs.put(10.6, "Snow Leopard");
        macOs.put(10.7, "Snow Lion");
        macOs.put(10.8, "Mountain Lion");
        macOs.put(10.9, "Mavericks");
        macOs.put(10.1, "Yosemite");
        darwin.put(5, "Puma");
        darwin.put(6, "Jaguar");
        darwin.put(7, "Panther");
        darwin.put(8, "Tiger");
        darwin.put(9, "Leopard");
        darwin.put(10, "Snow Leopard");
        darwin.put(11, "Lion");
        darwin.put(12, "Mountain Lion");
        darwin.put(13, "Mavericks");
        darwin.put(14, "Yosemite");
        linux.addAll(Arrays.asList("Linux", "SunOS"));
    }

    class OsInfo {
        private String name;
        private String arch;
        private String version;
        private String platformName;

        private OsInfo(String name, String version, String arch, String platformName) {
            this.name = name;
            this.arch = arch;
            this.version = version;
            this.platformName = platformName;
        }

        public String getName() {
            return this.name;
        }

        public String getArch() {
            return this.arch;
        }

        public String getVersion() {
            return this.version;
        }

        public String getPlatformName() {
            return this.platformName;
        }
    }

    private static class SingletonHolder {
        static String name = System.getProperty("os.name");
        static String version = System.getProperty("os.version");
        static String arch = System.getProperty("os.arch");
        private static final OS instance = new OS(name, version, arch);

        private SingletonHolder() {
        }
    }
}

