/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc;

import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.BitMixer;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.HashOrderMixing;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.ShortCharHashMap;

public class ShortCharScatterMap
extends ShortCharHashMap {
    public ShortCharScatterMap() {
        this(4);
    }

    public ShortCharScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ShortCharScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(short key) {
        return BitMixer.mixPhi(key);
    }

    public static ShortCharScatterMap from(short[] keys, char[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortCharScatterMap map = new ShortCharScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

