/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search;

import java.io.IOException;
import java.util.List;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.DisiWrapper;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.DisjunctionScorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Weight;

final class DisjunctionMaxScorer
extends DisjunctionScorer {
    private final float tieBreakerMultiplier;

    DisjunctionMaxScorer(Weight weight, float tieBreakerMultiplier, List<Scorer> subScorers, boolean needsScores) {
        super(weight, subScorers, needsScores);
        this.tieBreakerMultiplier = tieBreakerMultiplier;
    }

    @Override
    protected float score(DisiWrapper topList) throws IOException {
        float scoreSum = 0.0f;
        float scoreMax = Float.NEGATIVE_INFINITY;
        DisiWrapper w = topList;
        while (w != null) {
            float subScore = w.scorer.score();
            scoreSum += subScore;
            if (subScore > scoreMax) {
                scoreMax = subScore;
            }
            w = w.next;
        }
        return scoreMax + (scoreSum - scoreMax) * this.tieBreakerMultiplier;
    }
}

