/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.template.put;

import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.MetaDataIndexTemplateService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.IndexScopedSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportService;

public class TransportPutIndexTemplateAction
extends TransportMasterNodeAction<PutIndexTemplateRequest, PutIndexTemplateResponse> {
    private final MetaDataIndexTemplateService indexTemplateService;
    private final IndexScopedSettings indexScopedSettings;

    @Inject
    public TransportPutIndexTemplateAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexScopedSettings indexScopedSettings) {
        super(settings, "indices:admin/template/put", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, PutIndexTemplateRequest::new);
        this.indexTemplateService = indexTemplateService;
        this.indexScopedSettings = indexScopedSettings;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected PutIndexTemplateResponse newResponse() {
        return new PutIndexTemplateResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(PutIndexTemplateRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, "");
    }

    @Override
    protected void masterOperation(final PutIndexTemplateRequest request, ClusterState state, final ActionListener<PutIndexTemplateResponse> listener) {
        String cause = request.cause();
        if (cause.length() == 0) {
            cause = "api";
        }
        Settings.Builder templateSettingsBuilder = Settings.builder();
        templateSettingsBuilder.put(request.settings()).normalizePrefix("index.");
        this.indexScopedSettings.validate(templateSettingsBuilder);
        this.indexTemplateService.putTemplate(new MetaDataIndexTemplateService.PutRequest(cause, request.name()).template(request.template()).order(request.order()).settings(templateSettingsBuilder.build()).mappings(request.mappings()).aliases(request.aliases()).customs(request.customs()).create(request.create()).masterTimeout(request.masterNodeTimeout()).version(request.version()), new MetaDataIndexTemplateService.PutListener(){

            @Override
            public void onResponse(MetaDataIndexTemplateService.PutResponse response) {
                listener.onResponse(new PutIndexTemplateResponse(response.acknowledged()));
            }

            @Override
            public void onFailure(Exception e) {
                TransportPutIndexTemplateAction.this.logger.debug(() -> new ParameterizedMessage("failed to put template [{}]", (Object)request.name()), (Throwable)e);
                listener.onFailure(e);
            }
        });
    }
}

