/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.bulk;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.bulk.BackoffPolicy;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.bulk.BulkProcessor;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.bulk.BulkRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.bulk.BulkResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.bulk.Retry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.Loggers;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;

abstract class BulkRequestHandler {
    protected final Logger logger = Loggers.getLogger(this.getClass());
    protected final BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer;
    protected final ThreadPool threadPool;

    protected BulkRequestHandler(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, ThreadPool threadPool) {
        this.consumer = consumer;
        this.threadPool = threadPool;
    }

    public abstract void execute(BulkRequest var1, long var2);

    public abstract boolean awaitClose(long var1, TimeUnit var3) throws InterruptedException;

    public static BulkRequestHandler syncHandler(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, BackoffPolicy backoffPolicy, BulkProcessor.Listener listener, ThreadPool threadPool) {
        return new SyncBulkRequestHandler(consumer, backoffPolicy, listener, threadPool);
    }

    public static BulkRequestHandler asyncHandler(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, BackoffPolicy backoffPolicy, BulkProcessor.Listener listener, ThreadPool threadPool, int concurrentRequests) {
        return new AsyncBulkRequestHandler(consumer, backoffPolicy, listener, threadPool, concurrentRequests);
    }

    private static class AsyncBulkRequestHandler
    extends BulkRequestHandler {
        private final BackoffPolicy backoffPolicy;
        private final BulkProcessor.Listener listener;
        private final Semaphore semaphore;
        private final int concurrentRequests;

        private AsyncBulkRequestHandler(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, BackoffPolicy backoffPolicy, BulkProcessor.Listener listener, ThreadPool threadPool, int concurrentRequests) {
            super(consumer, threadPool);
            this.backoffPolicy = backoffPolicy;
            assert (concurrentRequests > 0);
            this.listener = listener;
            this.concurrentRequests = concurrentRequests;
            this.semaphore = new Semaphore(concurrentRequests);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(final BulkRequest bulkRequest, final long executionId) {
            boolean bulkRequestSetupSuccessful = false;
            boolean acquired = false;
            try {
                this.listener.beforeBulk(executionId, bulkRequest);
                this.semaphore.acquire();
                acquired = true;
                Retry.on(EsRejectedExecutionException.class).policy(this.backoffPolicy).using(this.threadPool).withAsyncBackoff(this.consumer, bulkRequest, new ActionListener<BulkResponse>(){

                    @Override
                    public void onResponse(BulkResponse response) {
                        try {
                            listener.afterBulk(executionId, bulkRequest, response);
                        }
                        finally {
                            semaphore.release();
                        }
                    }

                    @Override
                    public void onFailure(Exception e) {
                        try {
                            listener.afterBulk(executionId, bulkRequest, e);
                        }
                        finally {
                            semaphore.release();
                        }
                    }
                }, Settings.EMPTY);
                bulkRequestSetupSuccessful = true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.info(() -> new ParameterizedMessage("Bulk request {} has been cancelled.", (Object)executionId), (Throwable)e);
                this.listener.afterBulk(executionId, bulkRequest, e);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("Failed to execute bulk request {}.", (Object)executionId), (Throwable)e);
                this.listener.afterBulk(executionId, bulkRequest, e);
            }
            finally {
                if (!bulkRequestSetupSuccessful && acquired) {
                    this.semaphore.release();
                }
            }
        }

        @Override
        public boolean awaitClose(long timeout, TimeUnit unit) throws InterruptedException {
            if (this.semaphore.tryAcquire(this.concurrentRequests, timeout, unit)) {
                this.semaphore.release(this.concurrentRequests);
                return true;
            }
            return false;
        }
    }

    private static class SyncBulkRequestHandler
    extends BulkRequestHandler {
        private final BulkProcessor.Listener listener;
        private final BackoffPolicy backoffPolicy;

        SyncBulkRequestHandler(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, BackoffPolicy backoffPolicy, BulkProcessor.Listener listener, ThreadPool threadPool) {
            super(consumer, threadPool);
            this.backoffPolicy = backoffPolicy;
            this.listener = listener;
        }

        @Override
        public void execute(BulkRequest bulkRequest, long executionId) {
            block4: {
                boolean afterCalled = false;
                try {
                    this.listener.beforeBulk(executionId, bulkRequest);
                    BulkResponse bulkResponse = Retry.on(EsRejectedExecutionException.class).policy(this.backoffPolicy).using(this.threadPool).withSyncBackoff(this.consumer, bulkRequest, Settings.EMPTY);
                    afterCalled = true;
                    this.listener.afterBulk(executionId, bulkRequest, bulkResponse);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.logger.info(() -> new ParameterizedMessage("Bulk request {} has been cancelled.", (Object)executionId), (Throwable)e);
                    if (!afterCalled) {
                        this.listener.afterBulk(executionId, bulkRequest, e);
                    }
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("Failed to execute bulk request {}.", (Object)executionId), (Throwable)e);
                    if (afterCalled) break block4;
                    this.listener.afterBulk(executionId, bulkRequest, e);
                }
            }
        }

        @Override
        public boolean awaitClose(long timeout, TimeUnit unit) throws InterruptedException {
            return true;
        }
    }
}

