/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.bulk;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.bulk.BackoffPolicy;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.bulk.BulkItemResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.bulk.BulkRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.bulk.BulkResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.PlainActionFuture;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.Loggers;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.FutureUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;

public class Retry {
    private final Class<? extends Throwable> retryOnThrowable;
    private BackoffPolicy backoffPolicy;
    private ThreadPool threadPool;

    public static Retry on(Class<? extends Throwable> retryOnThrowable) {
        return new Retry(retryOnThrowable);
    }

    Retry(Class<? extends Throwable> retryOnThrowable) {
        this.retryOnThrowable = retryOnThrowable;
    }

    public Retry policy(BackoffPolicy backoffPolicy) {
        this.backoffPolicy = backoffPolicy;
        return this;
    }

    public Retry using(ThreadPool threadPool) {
        this.threadPool = threadPool;
        return this;
    }

    public void withAsyncBackoff(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, BulkRequest bulkRequest, ActionListener<BulkResponse> listener, Settings settings) {
        RetryHandler r = new RetryHandler(this.retryOnThrowable, this.backoffPolicy, consumer, listener, settings, this.threadPool);
        r.execute(bulkRequest);
    }

    public BulkResponse withSyncBackoff(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, BulkRequest bulkRequest, Settings settings) throws Exception {
        PlainActionFuture<BulkResponse> actionFuture = PlainActionFuture.newFuture();
        RetryHandler r = new RetryHandler(this.retryOnThrowable, this.backoffPolicy, consumer, actionFuture, settings, this.threadPool);
        r.execute(bulkRequest);
        return (BulkResponse)actionFuture.actionGet();
    }

    static class RetryHandler
    implements ActionListener<BulkResponse> {
        private final Logger logger;
        private final ThreadPool threadPool;
        private final BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer;
        private final ActionListener<BulkResponse> listener;
        private final Iterator<TimeValue> backoff;
        private final Class<? extends Throwable> retryOnThrowable;
        private final List<BulkItemResponse> responses = new ArrayList<BulkItemResponse>();
        private final long startTimestampNanos;
        private volatile BulkRequest currentBulkRequest;
        private volatile ScheduledFuture<?> scheduledRequestFuture;

        RetryHandler(Class<? extends Throwable> retryOnThrowable, BackoffPolicy backoffPolicy, BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, ActionListener<BulkResponse> listener, Settings settings, ThreadPool threadPool) {
            this.retryOnThrowable = retryOnThrowable;
            this.backoff = backoffPolicy.iterator();
            this.consumer = consumer;
            this.listener = listener;
            this.logger = Loggers.getLogger(this.getClass(), settings, new String[0]);
            this.threadPool = threadPool;
            this.startTimestampNanos = System.nanoTime();
        }

        @Override
        public void onResponse(BulkResponse bulkItemResponses) {
            if (!bulkItemResponses.hasFailures()) {
                this.addResponses(bulkItemResponses, r -> true);
                this.finishHim();
            } else if (this.canRetry(bulkItemResponses)) {
                this.addResponses(bulkItemResponses, r -> !r.isFailed());
                this.retry(this.createBulkRequestForRetry(bulkItemResponses));
            } else {
                this.addResponses(bulkItemResponses, r -> true);
                this.finishHim();
            }
        }

        @Override
        public void onFailure(Exception e) {
            try {
                this.listener.onFailure(e);
            }
            finally {
                FutureUtils.cancel(this.scheduledRequestFuture);
            }
        }

        private void retry(BulkRequest bulkRequestForRetry) {
            assert (this.backoff.hasNext());
            TimeValue next = this.backoff.next();
            this.logger.trace("Retry of bulk request scheduled in {} ms.", (Object)next.millis());
            Runnable command = this.threadPool.getThreadContext().preserveContext(() -> this.execute(bulkRequestForRetry));
            this.scheduledRequestFuture = this.threadPool.schedule(next, "same", command);
        }

        private BulkRequest createBulkRequestForRetry(BulkResponse bulkItemResponses) {
            BulkRequest requestToReissue = new BulkRequest();
            int index = 0;
            for (BulkItemResponse bulkItemResponse : bulkItemResponses.getItems()) {
                if (bulkItemResponse.isFailed()) {
                    requestToReissue.add(this.currentBulkRequest.requests().get(index));
                }
                ++index;
            }
            return requestToReissue;
        }

        private boolean canRetry(BulkResponse bulkItemResponses) {
            if (!this.backoff.hasNext()) {
                return false;
            }
            for (BulkItemResponse bulkItemResponse : bulkItemResponses) {
                Exception cause;
                Throwable rootCause;
                if (!bulkItemResponse.isFailed() || (rootCause = ExceptionsHelper.unwrapCause(cause = bulkItemResponse.getFailure().getCause())).getClass().equals(this.retryOnThrowable)) continue;
                return false;
            }
            return true;
        }

        private void finishHim() {
            try {
                this.listener.onResponse(this.getAccumulatedResponse());
            }
            finally {
                FutureUtils.cancel(this.scheduledRequestFuture);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addResponses(BulkResponse response, Predicate<BulkItemResponse> filter) {
            for (BulkItemResponse bulkItemResponse : response) {
                if (!filter.test(bulkItemResponse)) continue;
                List<BulkItemResponse> list = this.responses;
                synchronized (list) {
                    this.responses.add(bulkItemResponse);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BulkResponse getAccumulatedResponse() {
            BulkItemResponse[] itemResponses;
            List<BulkItemResponse> list = this.responses;
            synchronized (list) {
                itemResponses = this.responses.toArray(new BulkItemResponse[1]);
            }
            long stopTimestamp = System.nanoTime();
            long totalLatencyMs = TimeValue.timeValueNanos(stopTimestamp - this.startTimestampNanos).millis();
            return new BulkResponse(itemResponses, totalLatencyMs);
        }

        public void execute(BulkRequest bulkRequest) {
            this.currentBulkRequest = bulkRequest;
            this.consumer.accept(bulkRequest, this);
        }
    }
}

