/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ingest;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.IngestDocument;

final class WriteableIngestDocument
implements Writeable,
ToXContent {
    private final IngestDocument ingestDocument;

    WriteableIngestDocument(IngestDocument ingestDocument) {
        assert (ingestDocument != null);
        this.ingestDocument = ingestDocument;
    }

    WriteableIngestDocument(StreamInput in) throws IOException {
        Map<String, Object> sourceAndMetadata = in.readMap();
        Map<String, Object> ingestMetadata = in.readMap();
        this.ingestDocument = new IngestDocument(sourceAndMetadata, ingestMetadata);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.ingestDocument.getSourceAndMetadata());
        out.writeMap(this.ingestDocument.getIngestMetadata());
    }

    IngestDocument getIngestDocument() {
        return this.ingestDocument;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("doc");
        Map<IngestDocument.MetaData, String> metadataMap = this.ingestDocument.extractMetadata();
        for (Map.Entry<IngestDocument.MetaData, String> metadata : metadataMap.entrySet()) {
            if (metadata.getValue() == null) continue;
            builder.field(metadata.getKey().getFieldName(), metadata.getValue());
        }
        builder.field("_source", this.ingestDocument.getSourceAndMetadata());
        builder.field("_ingest", this.ingestDocument.getIngestMetadata());
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteableIngestDocument that = (WriteableIngestDocument)o;
        return Objects.equals(this.ingestDocument, that.ingestDocument);
    }

    public int hashCode() {
        return Objects.hash(this.ingestDocument);
    }

    public String toString() {
        return this.ingestDocument.toString();
    }
}

