/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.NoShardAvailableActionException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchPhaseController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchShardIterator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.TransportActions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.ShardRouting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.AtomicArray;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.SearchPhaseResult;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.SearchShardTarget;

abstract class InitialSearchPhase<FirstResult extends SearchPhaseResult>
extends SearchPhase {
    private final SearchRequest request;
    private final GroupShardsIterator<SearchShardIterator> toSkipShardsIts;
    private final GroupShardsIterator<SearchShardIterator> shardsIts;
    private final Logger logger;
    private final int expectedTotalOps;
    private final AtomicInteger totalOps = new AtomicInteger();
    private final AtomicInteger shardExecutionIndex = new AtomicInteger(0);
    private final int maxConcurrentShardRequests;
    private final Executor executor;

    InitialSearchPhase(String name, SearchRequest request, GroupShardsIterator<SearchShardIterator> shardsIts, Logger logger, int maxConcurrentShardRequests, Executor executor) {
        super(name);
        this.request = request;
        ArrayList<SearchShardIterator> toSkipIterators = new ArrayList<SearchShardIterator>();
        ArrayList<SearchShardIterator> iterators = new ArrayList<SearchShardIterator>();
        for (SearchShardIterator iterator : shardsIts) {
            if (iterator.skip()) {
                toSkipIterators.add(iterator);
                continue;
            }
            iterators.add(iterator);
        }
        this.toSkipShardsIts = new GroupShardsIterator(toSkipIterators);
        this.shardsIts = new GroupShardsIterator(iterators);
        this.logger = logger;
        this.expectedTotalOps = shardsIts.totalSizeWith1ForEmpty();
        this.maxConcurrentShardRequests = Math.min(maxConcurrentShardRequests, shardsIts.size());
        this.executor = executor;
    }

    private void onShardFailure(int shardIndex, @Nullable ShardRouting shard, @Nullable String nodeId, SearchShardIterator shardIt, Exception e) {
        SearchShardTarget shardTarget = new SearchShardTarget(nodeId, shardIt.shardId(), shardIt.getClusterAlias(), shardIt.getOriginalIndices());
        this.onShardFailure(shardIndex, shardTarget, e);
        if (this.totalOps.incrementAndGet() == this.expectedTotalOps) {
            if (this.logger.isDebugEnabled()) {
                if (e != null && !TransportActions.isShardNotAvailableException(e)) {
                    this.logger.debug(() -> new ParameterizedMessage("{}: Failed to execute [{}]", shard != null ? shard.shortSummary() : shardIt.shardId(), (Object)this.request), (Throwable)e);
                } else if (this.logger.isTraceEnabled()) {
                    this.logger.trace(() -> new ParameterizedMessage("{}: Failed to execute [{}]", (Object)shard, (Object)this.request), (Throwable)e);
                }
            }
            this.onPhaseDone();
        } else {
            ShardRouting nextShard = shardIt.nextOrNull();
            boolean lastShard = nextShard == null;
            this.logger.trace(() -> new ParameterizedMessage("{}: Failed to execute [{}] lastShard [{}]", shard != null ? shard.shortSummary() : shardIt.shardId(), this.request, lastShard), (Throwable)e);
            if (!lastShard) {
                this.performPhaseOnShard(shardIndex, shardIt, nextShard);
            } else {
                this.maybeExecuteNext();
                if (this.logger.isDebugEnabled() && !this.logger.isTraceEnabled() && e != null && !TransportActions.isShardNotAvailableException(e)) {
                    this.logger.debug(() -> new ParameterizedMessage("{}: Failed to execute [{}] lastShard [{}]", shard != null ? shard.shortSummary() : shardIt.shardId(), this.request, lastShard), (Throwable)e);
                }
            }
        }
    }

    @Override
    public final void run() throws IOException {
        for (SearchShardIterator iterator : this.toSkipShardsIts) {
            assert (iterator.skip());
            this.skipShard(iterator);
        }
        if (this.shardsIts.size() > 0) {
            int maxConcurrentShardRequests = Math.min(this.maxConcurrentShardRequests, this.shardsIts.size());
            boolean success = this.shardExecutionIndex.compareAndSet(0, maxConcurrentShardRequests);
            assert (success);
            for (int index = 0; index < maxConcurrentShardRequests; ++index) {
                SearchShardIterator shardRoutings = this.shardsIts.get(index);
                assert (!shardRoutings.skip());
                this.performPhaseOnShard(index, shardRoutings, shardRoutings.nextOrNull());
            }
        }
    }

    private void maybeExecuteNext() {
        int index = this.shardExecutionIndex.getAndIncrement();
        if (index < this.shardsIts.size()) {
            SearchShardIterator shardRoutings = this.shardsIts.get(index);
            this.performPhaseOnShard(index, shardRoutings, shardRoutings.nextOrNull());
        }
    }

    private void maybeFork(Thread thread, Runnable runnable) {
        if (thread == Thread.currentThread()) {
            this.fork(runnable);
        } else {
            runnable.run();
        }
    }

    private void fork(final Runnable runnable) {
        this.executor.execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
            }

            @Override
            protected void doRun() throws Exception {
                runnable.run();
            }

            @Override
            public boolean isForceExecution() {
                return true;
            }
        });
    }

    private void performPhaseOnShard(final int shardIndex, final SearchShardIterator shardIt, final ShardRouting shard) {
        final Thread thread = Thread.currentThread();
        if (shard == null) {
            this.fork(() -> this.onShardFailure(shardIndex, null, null, shardIt, new NoShardAvailableActionException(shardIt.shardId())));
        } else {
            try {
                this.executePhaseOnShard(shardIt, shard, new SearchActionListener<FirstResult>(new SearchShardTarget(shard.currentNodeId(), shardIt.shardId(), shardIt.getClusterAlias(), shardIt.getOriginalIndices()), shardIndex){

                    @Override
                    public void innerOnResponse(FirstResult result) {
                        InitialSearchPhase.this.maybeFork(thread, () -> InitialSearchPhase.this.onShardResult(result, shardIt));
                    }

                    @Override
                    public void onFailure(Exception t) {
                        InitialSearchPhase.this.maybeFork(thread, () -> InitialSearchPhase.this.onShardFailure(shardIndex, shard, shard.currentNodeId(), shardIt, t));
                    }
                });
            }
            catch (Exception e) {
                this.fork(() -> this.onShardFailure(shardIndex, shard, shard.currentNodeId(), shardIt, e));
            }
        }
    }

    private void onShardResult(FirstResult result, SearchShardIterator shardIt) {
        assert (((SearchPhaseResult)result).getShardIndex() != -1) : "shard index is not set";
        assert (((SearchPhaseResult)result).getSearchShardTarget() != null) : "search shard target must not be null";
        this.onShardSuccess(result);
        this.successfulShardExecution(shardIt);
    }

    private void successfulShardExecution(SearchShardIterator shardsIt) {
        int remainingOpsOnIterator = shardsIt.skip() ? shardsIt.remaining() : shardsIt.remaining() + 1;
        int xTotalOps = this.totalOps.addAndGet(remainingOpsOnIterator);
        if (xTotalOps == this.expectedTotalOps) {
            this.onPhaseDone();
        } else {
            if (xTotalOps > this.expectedTotalOps) {
                StringBuilder toSkipShardsIds = new StringBuilder();
                this.toSkipShardsIts.forEach(s -> toSkipShardsIds.append(s.shardId()).append(","));
                throw new AssertionError((Object)("unexpected higher total ops [" + xTotalOps + "] compared to expected [" + this.expectedTotalOps + "]. Last successful shard info: shardId: [" + shardsIt.shardId() + "], shardRoutings: [" + shardsIt.getShardRoutings() + "]. Shards set to skip: [" + toSkipShardsIds + "]"));
            }
            if (!shardsIt.skip()) {
                this.maybeExecuteNext();
            }
        }
    }

    abstract void onPhaseDone();

    abstract void onShardFailure(int var1, SearchShardTarget var2, Exception var3);

    abstract void onShardSuccess(FirstResult var1);

    protected abstract void executePhaseOnShard(SearchShardIterator var1, ShardRouting var2, SearchActionListener<FirstResult> var3);

    protected void skipShard(SearchShardIterator iterator) {
        assert (iterator.skip());
        this.successfulShardExecution(iterator);
    }

    static class ArraySearchPhaseResults<Result extends SearchPhaseResult>
    extends SearchPhaseResults<Result> {
        final AtomicArray<Result> results;

        ArraySearchPhaseResults(int size) {
            super(size);
            this.results = new AtomicArray(size);
        }

        @Override
        Stream<Result> getSuccessfulResults() {
            return this.results.asList().stream();
        }

        @Override
        void consumeResult(Result result) {
            assert (this.results.get(((SearchPhaseResult)result).getShardIndex()) == null) : "shardIndex: " + ((SearchPhaseResult)result).getShardIndex() + " is already set";
            this.results.set(((SearchPhaseResult)result).getShardIndex(), result);
        }

        @Override
        boolean hasResult(int shardIndex) {
            return this.results.get(shardIndex) != null;
        }

        @Override
        AtomicArray<Result> getAtomicArray() {
            return this.results;
        }
    }

    static abstract class SearchPhaseResults<Result extends SearchPhaseResult> {
        private final int numShards;

        protected SearchPhaseResults(int numShards) {
            this.numShards = numShards;
        }

        final int getNumShards() {
            return this.numShards;
        }

        abstract Stream<Result> getSuccessfulResults();

        abstract void consumeResult(Result var1);

        abstract boolean hasResult(int var1);

        void consumeShardFailure(int shardIndex) {
        }

        AtomicArray<Result> getAtomicArray() {
            throw new UnsupportedOperationException();
        }

        SearchPhaseController.ReducedQueryPhase reduce() {
            throw new UnsupportedOperationException("reduce is not supported");
        }
    }
}

