/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.DfsQueryPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.FetchSearchPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.InitialSearchPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchPhaseContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchPhaseController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchShardIterator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchTask;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchTransportService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.TransportSearchAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.ShardRouting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.SearchPhaseResult;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.dfs.DfsSearchResult;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.AliasFilter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.Transport;

final class SearchDfsQueryThenFetchAsyncAction
extends AbstractSearchAsyncAction<DfsSearchResult> {
    private final SearchPhaseController searchPhaseController;

    SearchDfsQueryThenFetchAsyncAction(Logger logger, SearchTransportService searchTransportService, BiFunction<String, String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, SearchPhaseController searchPhaseController, Executor executor, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, long clusterStateVersion, SearchTask task) {
        super("dfs", logger, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, executor, request, listener, shardsIts, timeProvider, clusterStateVersion, task, new InitialSearchPhase.ArraySearchPhaseResults(shardsIts.size()), request.getMaxConcurrentShardRequests());
        this.searchPhaseController = searchPhaseController;
    }

    @Override
    protected void executePhaseOnShard(SearchShardIterator shardIt, ShardRouting shard, SearchActionListener<DfsSearchResult> listener) {
        this.getSearchTransport().sendExecuteDfs(this.getConnection(shardIt.getClusterAlias(), shard.currentNodeId()), this.buildShardSearchRequest(shardIt), this.getTask(), listener);
    }

    @Override
    protected SearchPhase getNextPhase(InitialSearchPhase.SearchPhaseResults<DfsSearchResult> results, SearchPhaseContext context) {
        return new DfsQueryPhase(results.getAtomicArray(), this.searchPhaseController, queryResults -> new FetchSearchPhase((InitialSearchPhase.SearchPhaseResults<SearchPhaseResult>)queryResults, this.searchPhaseController, context), context);
    }
}

