/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.bootstrap;

import java.io.IOError;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;
import java.util.function.Supplier;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.SuppressForbidden;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.Loggers;

class ElasticsearchUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final Supplier<String> loggingPrefixSupplier;

    ElasticsearchUncaughtExceptionHandler(Supplier<String> loggingPrefixSupplier) {
        this.loggingPrefixSupplier = Objects.requireNonNull(loggingPrefixSupplier);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (ElasticsearchUncaughtExceptionHandler.isFatalUncaught(e)) {
            try {
                this.onFatalUncaught(t.getName(), e);
            }
            finally {
                if (e instanceof InternalError) {
                    this.halt(128);
                } else if (e instanceof OutOfMemoryError) {
                    this.halt(127);
                } else if (e instanceof StackOverflowError) {
                    this.halt(126);
                } else if (e instanceof UnknownError) {
                    this.halt(125);
                } else if (e instanceof IOError) {
                    this.halt(124);
                } else {
                    this.halt(1);
                }
            }
        } else {
            this.onNonFatalUncaught(t.getName(), e);
        }
    }

    static boolean isFatalUncaught(Throwable e) {
        return e instanceof Error;
    }

    void onFatalUncaught(String threadName, Throwable t) {
        Logger logger = Loggers.getLogger(ElasticsearchUncaughtExceptionHandler.class, this.loggingPrefixSupplier.get());
        logger.error(() -> new ParameterizedMessage("fatal error in thread [{}], exiting", (Object)threadName), t);
    }

    void onNonFatalUncaught(String threadName, Throwable t) {
        Logger logger = Loggers.getLogger(ElasticsearchUncaughtExceptionHandler.class, this.loggingPrefixSupplier.get());
        logger.warn(() -> new ParameterizedMessage("uncaught exception in thread [{}]", (Object)threadName), t);
    }

    void halt(int status) {
        AccessController.doPrivileged(new PrivilegedHaltAction(status));
    }

    static class PrivilegedHaltAction
    implements PrivilegedAction<Void> {
        private final int status;

        private PrivilegedHaltAction(int status) {
            this.status = status;
        }

        @Override
        @SuppressForbidden(reason="halt")
        public Void run() {
            Runtime.getRuntime().halt(this.status);
            return null;
        }
    }
}

