/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.bootstrap;

import java.util.Arrays;
import java.util.List;
import org.graylog.shaded.elasticsearch5.com.sun.jna.Native;
import org.graylog.shaded.elasticsearch5.com.sun.jna.NativeLong;
import org.graylog.shaded.elasticsearch5.com.sun.jna.Structure;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Constants;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.Loggers;

final class JNACLibrary {
    private static final Logger logger = Loggers.getLogger(JNACLibrary.class);
    public static final int MCL_CURRENT = 1;
    public static final int ENOMEM = 12;
    public static final int RLIMIT_MEMLOCK = Constants.MAC_OS_X ? 6 : 8;
    public static final int RLIMIT_AS = Constants.MAC_OS_X ? 5 : 9;
    public static final int RLIMIT_FSIZE = Constants.MAC_OS_X ? 1 : 1;
    public static final long RLIM_INFINITY = Constants.MAC_OS_X ? Long.MAX_VALUE : -1L;

    static native int mlockall(int var0);

    static native int geteuid();

    static native int getrlimit(int var0, Rlimit var1);

    static native int setrlimit(int var0, Rlimit var1);

    static native String strerror(int var0);

    private JNACLibrary() {
    }

    static {
        try {
            Native.register("c");
        }
        catch (UnsatisfiedLinkError e) {
            logger.warn("unable to link C library. native methods (mlockall) will be disabled.", (Throwable)e);
        }
    }

    public static final class Rlimit
    extends Structure
    implements Structure.ByReference {
        public NativeLong rlim_cur = new NativeLong(0L);
        public NativeLong rlim_max = new NativeLong(0L);

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("rlim_cur", "rlim_max");
        }
    }
}

