/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.bootstrap;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Constants;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.IOUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.bootstrap.Natives;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.FileSystemUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.plugins.Platforms;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.plugins.PluginInfo;

final class Spawner
implements Closeable {
    private final List<Process> processes = new ArrayList<Process>();
    private AtomicBoolean spawned = new AtomicBoolean();

    Spawner() {
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(() -> this.processes.stream().map(s -> s::destroy).iterator());
    }

    void spawnNativePluginControllers(Environment environment) throws IOException {
        if (!this.spawned.compareAndSet(false, true)) {
            throw new IllegalStateException("native controllers already spawned");
        }
        Path pluginsFile = environment.pluginsFile();
        if (!Files.exists(pluginsFile, new LinkOption[0])) {
            throw new IllegalStateException("plugins directory [" + pluginsFile + "] not found");
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(pluginsFile);){
            for (Path plugin : stream) {
                if (FileSystemUtils.isDesktopServicesStore(plugin)) continue;
                PluginInfo info = PluginInfo.readFromProperties(plugin);
                Path spawnPath = Platforms.nativeControllerPath(plugin);
                if (!Files.isRegularFile(spawnPath, new LinkOption[0])) continue;
                if (!info.hasNativeController()) {
                    String message = String.format(Locale.ROOT, "plugin [%s] does not have permission to fork native controller", plugin.getFileName());
                    throw new IllegalArgumentException(message);
                }
                Process process = this.spawnNativePluginController(spawnPath, environment.tmpFile());
                this.processes.add(process);
            }
        }
    }

    private Process spawnNativePluginController(Path spawnPath, Path tmpPath) throws IOException {
        String command = Constants.WINDOWS ? Natives.getShortPathName(spawnPath.toString()) : spawnPath.toString();
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.environment().clear();
        pb.environment().put("TMPDIR", tmpPath.toString());
        return pb.start();
    }

    List<Process> getProcesses() {
        return Collections.unmodifiableList(this.processes);
    }
}

