/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.action.shard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterChangedEvent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterStateObserver;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterStateTaskListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.MasterNodeChangePredicate;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.NotMasterException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.RoutingService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.ShardRouting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.FailedShard;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.StaleShard;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Priority;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.AbstractComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.Discovery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.ShardId;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.node.NodeClosedException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.ConnectTransportException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.RemoteTransportException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportRequestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportService;

public class ShardStateAction
extends AbstractComponent {
    public static final String SHARD_STARTED_ACTION_NAME = "internal:cluster/shard/started";
    public static final String SHARD_FAILED_ACTION_NAME = "internal:cluster/shard/failure";
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private static Class[] MASTER_CHANNEL_EXCEPTIONS = new Class[]{NotMasterException.class, ConnectTransportException.class, Discovery.FailedToCommitClusterStateException.class};

    @Inject
    public ShardStateAction(Settings settings, ClusterService clusterService, TransportService transportService, AllocationService allocationService, RoutingService routingService, ThreadPool threadPool) {
        super(settings);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        transportService.registerRequestHandler(SHARD_STARTED_ACTION_NAME, ShardEntry::new, "same", new ShardStartedTransportHandler(clusterService, new ShardStartedClusterStateTaskExecutor(allocationService, this.logger), this.logger));
        transportService.registerRequestHandler(SHARD_FAILED_ACTION_NAME, ShardEntry::new, "same", new ShardFailedTransportHandler(clusterService, new ShardFailedClusterStateTaskExecutor(allocationService, routingService, this.logger), this.logger));
    }

    private void sendShardAction(final String actionName, ClusterState currentState, final ShardEntry shardEntry, final Listener listener) {
        final ClusterStateObserver observer = new ClusterStateObserver(currentState, this.clusterService, null, this.logger, this.threadPool.getThreadContext());
        final DiscoveryNode masterNode = currentState.nodes().getMasterNode();
        final Predicate<ClusterState> changePredicate = MasterNodeChangePredicate.build(currentState);
        if (masterNode == null) {
            this.logger.warn("{} no master known for action [{}] for shard entry [{}]", (Object)shardEntry.shardId, (Object)actionName, (Object)shardEntry);
            this.waitForNewMasterAndRetry(actionName, observer, shardEntry, listener, changePredicate);
        } else {
            this.logger.debug("{} sending [{}] to [{}] for shard entry [{}]", (Object)shardEntry.shardId, (Object)actionName, (Object)masterNode.getId(), (Object)shardEntry);
            this.transportService.sendRequest(masterNode, actionName, shardEntry, new EmptyTransportResponseHandler("same"){

                @Override
                public void handleResponse(TransportResponse.Empty response) {
                    listener.onSuccess();
                }

                @Override
                public void handleException(TransportException exp) {
                    if (ShardStateAction.isMasterChannelException(exp)) {
                        ShardStateAction.this.waitForNewMasterAndRetry(actionName, observer, shardEntry, listener, changePredicate);
                    } else {
                        ShardStateAction.this.logger.warn(() -> new ParameterizedMessage("{} unexpected failure while sending request [{}] to [{}] for shard entry [{}]", shardEntry2.shardId, actionName, masterNode, shardEntry), (Throwable)exp);
                        listener.onFailure(exp instanceof RemoteTransportException ? (Exception)(exp.getCause() instanceof Exception ? exp.getCause() : new ElasticsearchException(exp.getCause())) : exp);
                    }
                }
            });
        }
    }

    private static boolean isMasterChannelException(TransportException exp) {
        return ExceptionsHelper.unwrap(exp, MASTER_CHANNEL_EXCEPTIONS) != null;
    }

    public void remoteShardFailed(ShardId shardId, String allocationId, long primaryTerm, String message, @Nullable Exception failure, Listener listener) {
        assert (primaryTerm > 0L) : "primary term should be strictly positive";
        this.shardFailed(shardId, allocationId, primaryTerm, message, failure, listener, this.clusterService.state());
    }

    public void localShardFailed(ShardRouting shardRouting, String message, @Nullable Exception failure, Listener listener) {
        this.localShardFailed(shardRouting, message, failure, listener, this.clusterService.state());
    }

    public void localShardFailed(ShardRouting shardRouting, String message, @Nullable Exception failure, Listener listener, ClusterState currentState) {
        this.shardFailed(shardRouting.shardId(), shardRouting.allocationId().getId(), 0L, message, failure, listener, currentState);
    }

    private void shardFailed(ShardId shardId, String allocationId, long primaryTerm, String message, @Nullable Exception failure, Listener listener, ClusterState currentState) {
        ShardEntry shardEntry = new ShardEntry(shardId, allocationId, primaryTerm, message, failure);
        this.sendShardAction(SHARD_FAILED_ACTION_NAME, currentState, shardEntry, listener);
    }

    protected void waitForNewMasterAndRetry(final String actionName, ClusterStateObserver observer, final ShardEntry shardEntry, final Listener listener, Predicate<ClusterState> changePredicate) {
        observer.waitForNextChange(new ClusterStateObserver.Listener(){

            @Override
            public void onNewClusterState(ClusterState state) {
                if (ShardStateAction.this.logger.isTraceEnabled()) {
                    ShardStateAction.this.logger.trace("new cluster state [{}] after waiting for master election to fail shard entry [{}]", (Object)state, (Object)shardEntry);
                }
                ShardStateAction.this.sendShardAction(actionName, state, shardEntry, listener);
            }

            @Override
            public void onClusterServiceClose() {
                ShardStateAction.this.logger.warn(() -> new ParameterizedMessage("{} node closed while execution action [{}] for shard entry [{}]", shardEntry2.shardId, actionName, shardEntry), (Throwable)shardEntry.failure);
                listener.onFailure(new NodeClosedException(ShardStateAction.this.clusterService.localNode()));
            }

            @Override
            public void onTimeout(TimeValue timeout) {
                assert (false);
            }
        }, changePredicate);
    }

    public void shardStarted(ShardRouting shardRouting, String message, Listener listener) {
        this.shardStarted(shardRouting, message, listener, this.clusterService.state());
    }

    public void shardStarted(ShardRouting shardRouting, String message, Listener listener, ClusterState currentState) {
        ShardEntry shardEntry = new ShardEntry(shardRouting.shardId(), shardRouting.allocationId().getId(), 0L, message, null);
        this.sendShardAction(SHARD_STARTED_ACTION_NAME, currentState, shardEntry, listener);
    }

    public static class NoLongerPrimaryShardException
    extends ElasticsearchException {
        public NoLongerPrimaryShardException(ShardId shardId, String msg) {
            super(msg, new Object[0]);
            this.setShard(shardId);
        }

        public NoLongerPrimaryShardException(StreamInput in) throws IOException {
            super(in);
        }
    }

    public static interface Listener {
        default public void onSuccess() {
        }

        default public void onFailure(Exception e) {
        }
    }

    public static class ShardEntry
    extends TransportRequest {
        ShardId shardId;
        String allocationId;
        long primaryTerm;
        String message;
        Exception failure;

        public ShardEntry() {
        }

        public ShardEntry(ShardId shardId, String allocationId, long primaryTerm, String message, @Nullable Exception failure) {
            this.shardId = shardId;
            this.allocationId = allocationId;
            this.primaryTerm = primaryTerm;
            this.message = message;
            this.failure = failure;
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        public String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = ShardId.readShardId(in);
            this.allocationId = in.readString();
            this.primaryTerm = in.readVLong();
            this.message = in.readString();
            this.failure = in.readException();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeString(this.allocationId);
            out.writeVLong(this.primaryTerm);
            out.writeString(this.message);
            out.writeException(this.failure);
        }

        public String toString() {
            ArrayList<String> components = new ArrayList<String>(4);
            components.add("shard id [" + this.shardId + "]");
            components.add("allocation id [" + this.allocationId + "]");
            components.add("primary term [" + this.primaryTerm + "]");
            components.add("message [" + this.message + "]");
            if (this.failure != null) {
                components.add("failure [" + ExceptionsHelper.detailedMessage(this.failure) + "]");
            }
            return String.join((CharSequence)", ", components);
        }
    }

    public static class ShardStartedClusterStateTaskExecutor
    implements ClusterStateTaskExecutor<ShardEntry>,
    ClusterStateTaskListener {
        private final AllocationService allocationService;
        private final Logger logger;

        public ShardStartedClusterStateTaskExecutor(AllocationService allocationService, Logger logger) {
            this.allocationService = allocationService;
            this.logger = logger;
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<ShardEntry> execute(ClusterState currentState, List<ShardEntry> tasks) throws Exception {
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<ShardEntry> builder = ClusterStateTaskExecutor.ClusterTasksResult.builder();
            ArrayList<ShardEntry> tasksToBeApplied = new ArrayList<ShardEntry>();
            ArrayList<ShardRouting> shardRoutingsToBeApplied = new ArrayList<ShardRouting>(tasks.size());
            HashSet<ShardRouting> seenShardRoutings = new HashSet<ShardRouting>();
            for (ShardEntry task : tasks) {
                assert (task.primaryTerm == 0L) : "shard is only started by itself: " + task;
                ShardRouting matched = currentState.getRoutingTable().getByAllocationId(task.shardId, task.allocationId);
                if (matched == null) {
                    this.logger.debug("{} ignoring shard started task [{}] (shard does not exist anymore)", (Object)task.shardId, (Object)task);
                    builder.success(task);
                    continue;
                }
                if (!matched.initializing()) {
                    assert (matched.active()) : "expected active shard routing for task " + task + " but found " + matched;
                    this.logger.debug("{} ignoring shard started task [{}] (shard exists but is not initializing: {})", (Object)task.shardId, (Object)task, (Object)matched);
                    builder.success(task);
                    continue;
                }
                if (seenShardRoutings.contains(matched)) {
                    this.logger.trace("{} ignoring shard started task [{}] (already scheduled to start {})", (Object)task.shardId, (Object)task, (Object)matched);
                    tasksToBeApplied.add(task);
                    continue;
                }
                this.logger.debug("{} starting shard {} (shard started task: [{}])", (Object)task.shardId, (Object)matched, (Object)task);
                tasksToBeApplied.add(task);
                shardRoutingsToBeApplied.add(matched);
                seenShardRoutings.add(matched);
            }
            assert (tasksToBeApplied.size() >= shardRoutingsToBeApplied.size());
            ClusterState maybeUpdatedState = currentState;
            try {
                maybeUpdatedState = this.allocationService.applyStartedShards(currentState, shardRoutingsToBeApplied);
                builder.successes(tasksToBeApplied);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("failed to apply started shards {}", (Object)shardRoutingsToBeApplied), (Throwable)e);
                builder.failures(tasksToBeApplied, e);
            }
            return builder.build(maybeUpdatedState);
        }

        @Override
        public void onFailure(String source, Exception e) {
            this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
        }
    }

    private static class ShardStartedTransportHandler
    implements TransportRequestHandler<ShardEntry> {
        private final ClusterService clusterService;
        private final ShardStartedClusterStateTaskExecutor shardStartedClusterStateTaskExecutor;
        private final Logger logger;

        ShardStartedTransportHandler(ClusterService clusterService, ShardStartedClusterStateTaskExecutor shardStartedClusterStateTaskExecutor, Logger logger) {
            this.clusterService = clusterService;
            this.shardStartedClusterStateTaskExecutor = shardStartedClusterStateTaskExecutor;
            this.logger = logger;
        }

        @Override
        public void messageReceived(ShardEntry request, TransportChannel channel) throws Exception {
            this.logger.debug("{} received shard started for [{}]", (Object)request.shardId, (Object)request);
            this.clusterService.submitStateUpdateTask("shard-started " + request, request, ClusterStateTaskConfig.build(Priority.URGENT), this.shardStartedClusterStateTaskExecutor, this.shardStartedClusterStateTaskExecutor);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    public static class ShardFailedClusterStateTaskExecutor
    implements ClusterStateTaskExecutor<ShardEntry> {
        private final AllocationService allocationService;
        private final RoutingService routingService;
        private final Logger logger;

        public ShardFailedClusterStateTaskExecutor(AllocationService allocationService, RoutingService routingService, Logger logger) {
            this.allocationService = allocationService;
            this.routingService = routingService;
            this.logger = logger;
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<ShardEntry> execute(ClusterState currentState, List<ShardEntry> tasks) throws Exception {
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<ShardEntry> batchResultBuilder = ClusterStateTaskExecutor.ClusterTasksResult.builder();
            ArrayList<ShardEntry> tasksToBeApplied = new ArrayList<ShardEntry>();
            ArrayList<FailedShard> failedShardsToBeApplied = new ArrayList<FailedShard>();
            ArrayList<StaleShard> staleShardsToBeApplied = new ArrayList<StaleShard>();
            for (ShardEntry task : tasks) {
                long currentPrimaryTerm;
                IndexMetaData indexMetaData = currentState.metaData().index(task.shardId.getIndex());
                if (indexMetaData == null) {
                    this.logger.debug("{} ignoring shard failed task [{}] (unknown index {})", (Object)task.shardId, (Object)task, (Object)task.shardId.getIndex());
                    batchResultBuilder.success(task);
                    continue;
                }
                if (task.primaryTerm > 0L && (currentPrimaryTerm = indexMetaData.primaryTerm(task.shardId.id())) != task.primaryTerm) {
                    assert (currentPrimaryTerm > task.primaryTerm) : "received a primary term with a higher term than in the current cluster state (received [" + task.primaryTerm + "] but current is [" + currentPrimaryTerm + "])";
                    this.logger.debug("{} failing shard failed task [{}] (primary term {} does not match current term {})", (Object)task.shardId, (Object)task, (Object)task.primaryTerm, (Object)indexMetaData.primaryTerm(task.shardId.id()));
                    batchResultBuilder.failure(task, new NoLongerPrimaryShardException(task.shardId, "primary term [" + task.primaryTerm + "] did not match current primary term [" + currentPrimaryTerm + "]"));
                    continue;
                }
                ShardRouting matched = currentState.getRoutingTable().getByAllocationId(task.shardId, task.allocationId);
                if (matched == null) {
                    Set<String> inSyncAllocationIds = indexMetaData.inSyncAllocationIds(task.shardId.id());
                    if (task.primaryTerm > 0L && inSyncAllocationIds.contains(task.allocationId)) {
                        this.logger.debug("{} marking shard {} as stale (shard failed task: [{}])", (Object)task.shardId, (Object)task.allocationId, (Object)task);
                        tasksToBeApplied.add(task);
                        staleShardsToBeApplied.add(new StaleShard(task.shardId, task.allocationId));
                        continue;
                    }
                    this.logger.debug("{} ignoring shard failed task [{}] (shard does not exist anymore)", (Object)task.shardId, (Object)task);
                    batchResultBuilder.success(task);
                    continue;
                }
                this.logger.debug("{} failing shard {} (shard failed task: [{}])", (Object)task.shardId, (Object)matched, (Object)task);
                tasksToBeApplied.add(task);
                failedShardsToBeApplied.add(new FailedShard(matched, task.message, task.failure));
            }
            assert (tasksToBeApplied.size() == failedShardsToBeApplied.size() + staleShardsToBeApplied.size());
            ClusterState maybeUpdatedState = currentState;
            try {
                maybeUpdatedState = this.applyFailedShards(currentState, failedShardsToBeApplied, staleShardsToBeApplied);
                batchResultBuilder.successes(tasksToBeApplied);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("failed to apply failed shards {}", (Object)failedShardsToBeApplied), (Throwable)e);
                batchResultBuilder.failures(tasksToBeApplied, e);
            }
            return batchResultBuilder.build(maybeUpdatedState);
        }

        ClusterState applyFailedShards(ClusterState currentState, List<FailedShard> failedShards, List<StaleShard> staleShards) {
            return this.allocationService.applyFailedShards(currentState, failedShards, staleShards);
        }

        @Override
        public void clusterStatePublished(ClusterChangedEvent clusterChangedEvent) {
            int numberOfUnassignedShards = clusterChangedEvent.state().getRoutingNodes().unassigned().size();
            if (numberOfUnassignedShards > 0) {
                String reason = String.format(Locale.ROOT, "[%d] unassigned shards after failing shards", numberOfUnassignedShards);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("{}, scheduling a reroute", (Object)reason);
                }
                this.routingService.reroute(reason);
            }
        }
    }

    private static class ShardFailedTransportHandler
    implements TransportRequestHandler<ShardEntry> {
        private final ClusterService clusterService;
        private final ShardFailedClusterStateTaskExecutor shardFailedClusterStateTaskExecutor;
        private final Logger logger;

        ShardFailedTransportHandler(ClusterService clusterService, ShardFailedClusterStateTaskExecutor shardFailedClusterStateTaskExecutor, Logger logger) {
            this.clusterService = clusterService;
            this.shardFailedClusterStateTaskExecutor = shardFailedClusterStateTaskExecutor;
            this.logger = logger;
        }

        @Override
        public void messageReceived(final ShardEntry request, final TransportChannel channel) throws Exception {
            this.logger.warn(() -> new ParameterizedMessage("{} received shard failed for {}", (Object)request.shardId, (Object)request), (Throwable)request.failure);
            this.clusterService.submitStateUpdateTask("shard-failed", request, ClusterStateTaskConfig.build(Priority.HIGH), this.shardFailedClusterStateTaskExecutor, new ClusterStateTaskListener(){

                @Override
                public void onFailure(String source, Exception e) {
                    logger.error(() -> new ParameterizedMessage("{} unexpected failure while failing shard [{}]", (Object)request2.shardId, (Object)request), (Throwable)e);
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception channelException) {
                        channelException.addSuppressed(e);
                        logger.warn(() -> new ParameterizedMessage("{} failed to send failure [{}] while failing shard [{}]", request2.shardId, e, request), (Throwable)channelException);
                    }
                }

                @Override
                public void onNoLongerMaster(String source) {
                    logger.error("{} no longer master while failing shard [{}]", (Object)request.shardId, (Object)request);
                    try {
                        channel.sendResponse(new NotMasterException(source));
                    }
                    catch (Exception channelException) {
                        logger.warn(() -> new ParameterizedMessage("{} failed to send no longer master while failing shard [{}]", (Object)request2.shardId, (Object)request), (Throwable)channelException);
                    }
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    try {
                        channel.sendResponse(TransportResponse.Empty.INSTANCE);
                    }
                    catch (Exception channelException) {
                        logger.warn(() -> new ParameterizedMessage("{} failed to send response while failing shard [{}]", (Object)request2.shardId, (Object)request), (Throwable)channelException);
                    }
                }
            });
        }
    }
}

