/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.StreamSupport;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.Level;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.LogManager;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.core.LoggerContext;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.core.config.Configuration;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.core.config.Configurator;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.core.config.composite.CompositeConfiguration;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.core.config.properties.PropertiesConfigurationFactory;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.status.StatusConsoleListener;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.status.StatusData;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.status.StatusListener;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.status.StatusLogger;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cli.UserException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterName;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.SuppressForbidden;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.ESLoggerFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.Loggers;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.node.Node;

public class LogConfigurator {
    private static final AtomicBoolean error = new AtomicBoolean();
    private static final StatusListener ERROR_LISTENER = new StatusConsoleListener(Level.ERROR){

        @Override
        public void log(StatusData data) {
            error.set(true);
            super.log(data);
        }
    };

    public static void registerErrorListener() {
        error.set(false);
        StatusLogger.getLogger().registerListener(ERROR_LISTENER);
    }

    public static void configureWithoutConfig(Settings settings) {
        Objects.requireNonNull(settings);
        LogConfigurator.configureStatusLogger();
        LogConfigurator.configureLoggerLevels(settings);
    }

    public static void configure(Environment environment) throws IOException, UserException {
        Objects.requireNonNull(environment);
        try {
            LogConfigurator.checkErrorListener();
        }
        finally {
            StatusLogger.getLogger().removeListener(ERROR_LISTENER);
        }
        LogConfigurator.configure(environment.settings(), environment.configFile(), environment.logsFile());
    }

    private static void checkErrorListener() {
        assert (LogConfigurator.errorListenerIsRegistered()) : "expected error listener to be registered";
        if (error.get()) {
            throw new IllegalStateException("status logger logged an error before logging was configured");
        }
    }

    private static boolean errorListenerIsRegistered() {
        return StreamSupport.stream(StatusLogger.getLogger().getListeners().spliterator(), false).anyMatch(l -> l == ERROR_LISTENER);
    }

    private static void configure(Settings settings, Path configsPath, Path logsPath) throws IOException, UserException {
        Objects.requireNonNull(settings);
        Objects.requireNonNull(configsPath);
        Objects.requireNonNull(logsPath);
        LogConfigurator.setLogConfigurationSystemProperty(logsPath, settings);
        LogConfigurator.configureStatusLogger();
        final LoggerContext context = (LoggerContext)LogManager.getContext(false);
        final ArrayList configurations = new ArrayList();
        final PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory();
        EnumSet<FileVisitOption> options = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(configsPath, options, Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toString().equals("log4j2.properties")) {
                    configurations.add((PropertiesConfiguration)factory.getConfiguration(context, file.toString(), file.toUri()));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        if (configurations.isEmpty()) {
            throw new UserException(78, "no log4j2.properties found; tried [" + configsPath + "] and its subdirectories");
        }
        context.start((Configuration)new CompositeConfiguration(configurations));
        LogConfigurator.warnIfOldConfigurationFilePresent(configsPath);
        LogConfigurator.configureLoggerLevels(settings);
    }

    private static void configureStatusLogger() {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setStatusLevel(Level.ERROR);
        Configurator.initialize((Configuration)((Configuration)builder.build()));
    }

    private static void configureLoggerLevels(Settings settings) {
        if (ESLoggerFactory.LOG_DEFAULT_LEVEL_SETTING.exists(settings)) {
            Level level = ESLoggerFactory.LOG_DEFAULT_LEVEL_SETTING.get(settings);
            Loggers.setLevel(ESLoggerFactory.getRootLogger(), level);
        }
        Map<String, String> levels = settings.filter(ESLoggerFactory.LOG_LEVEL_SETTING::match).getAsMap();
        for (String key : levels.keySet()) {
            if (key.equals(ESLoggerFactory.LOG_DEFAULT_LEVEL_SETTING.getKey())) continue;
            Level level = ESLoggerFactory.LOG_LEVEL_SETTING.getConcreteSetting(key).get(settings);
            Loggers.setLevel(ESLoggerFactory.getLogger(key.substring("logger.".length())), level);
        }
    }

    private static void warnIfOldConfigurationFilePresent(Path configsPath) throws IOException {
        assert (Version.CURRENT.major < 6);
        final List<String> suffixes = Arrays.asList(".yml", ".yaml", ".json", ".properties");
        EnumSet<FileVisitOption> options = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(configsPath, options, Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String fileName = file.getFileName().toString();
                if (fileName.startsWith("logging")) {
                    for (String suffix : suffixes) {
                        if (!fileName.endsWith(suffix)) continue;
                        Loggers.getLogger(LogConfigurator.class).warn("ignoring unsupported logging configuration file [{}], logging is configured via [{}]", (Object)file.toString(), (Object)file.getParent().resolve("log4j2.properties"));
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @SuppressForbidden(reason="sets system property for logging configuration")
    private static void setLogConfigurationSystemProperty(Path logsPath, Settings settings) {
        System.setProperty("es.logs", logsPath.resolve(ClusterName.CLUSTER_NAME_SETTING.get(settings).value()).toString());
        System.setProperty("es.logs.base_path", logsPath.toString());
        System.setProperty("es.logs.cluster_name", ClusterName.CLUSTER_NAME_SETTING.get(settings).value());
        if (Node.NODE_NAME_SETTING.exists(settings)) {
            System.setProperty("es.logs.node_name", Node.NODE_NAME_SETTING.get(settings));
        }
    }
}

