/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.zen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.IOUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterChangedEvent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterName;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.Diff;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.IncompatibleClusterStateVersionException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.node.DiscoveryNodes;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.bytes.BytesReference;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.AbstractComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.compress.Compressor;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.compress.CompressorFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.AckClusterStatePublishResponseHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.BlockingClusterStatePublishResponseHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.Discovery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.DiscoverySettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.zen.PendingClusterStatesQueue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.zen.ZenDiscovery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.BytesTransportRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportRequestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportRequestOptions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportService;

public class PublishClusterStateAction
extends AbstractComponent {
    public static final String SEND_ACTION_NAME = "internal:discovery/zen/publish/send";
    public static final String COMMIT_ACTION_NAME = "internal:discovery/zen/publish/commit";
    public static final String SETTINGS_MAX_PENDING_CLUSTER_STATES = "discovery.zen.publish.max_pending_cluster_states";
    private final TransportService transportService;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final Supplier<ClusterState> clusterStateSupplier;
    private final NewPendingClusterStateListener newPendingClusterStatelistener;
    private final DiscoverySettings discoverySettings;
    private final ClusterName clusterName;
    private final PendingClusterStatesQueue pendingStatesQueue;
    private Object lastSeenClusterStateMutex = new Object();
    private ClusterState lastSeenClusterState;

    public PublishClusterStateAction(Settings settings, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, Supplier<ClusterState> clusterStateSupplier, NewPendingClusterStateListener listener, DiscoverySettings discoverySettings, ClusterName clusterName) {
        super(settings);
        this.transportService = transportService;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.clusterStateSupplier = clusterStateSupplier;
        this.newPendingClusterStatelistener = listener;
        this.discoverySettings = discoverySettings;
        this.clusterName = clusterName;
        this.pendingStatesQueue = new PendingClusterStatesQueue(this.logger, settings.getAsInt(SETTINGS_MAX_PENDING_CLUSTER_STATES, 25));
        transportService.registerRequestHandler(SEND_ACTION_NAME, BytesTransportRequest::new, "same", false, false, new SendClusterStateRequestHandler());
        transportService.registerRequestHandler(COMMIT_ACTION_NAME, CommitClusterStateRequest::new, "same", false, false, new CommitClusterStateRequestHandler());
    }

    public PendingClusterStatesQueue pendingStatesQueue() {
        return this.pendingStatesQueue;
    }

    public void publish(ClusterChangedEvent clusterChangedEvent, int minMasterNodes, Discovery.AckListener ackListener) throws Discovery.FailedToCommitClusterStateException {
        SendingController sendingController;
        HashMap<Version, BytesReference> serializedDiffs;
        HashMap<Version, BytesReference> serializedStates;
        boolean sendFullVersion;
        HashSet<DiscoveryNode> nodesToPublishTo;
        try {
            DiscoveryNodes nodes = clusterChangedEvent.state().nodes();
            nodesToPublishTo = new HashSet<DiscoveryNode>(nodes.getSize());
            DiscoveryNode localNode = nodes.getLocalNode();
            int totalMasterNodes = nodes.getMasterNodes().size();
            for (DiscoveryNode node : nodes) {
                if (node.equals(localNode)) continue;
                nodesToPublishTo.add(node);
            }
            sendFullVersion = !this.discoverySettings.getPublishDiff() || clusterChangedEvent.previousState() == null;
            serializedStates = new HashMap<Version, BytesReference>();
            serializedDiffs = new HashMap<Version, BytesReference>();
            this.buildDiffAndSerializeStates(clusterChangedEvent.state(), clusterChangedEvent.previousState(), nodesToPublishTo, sendFullVersion, serializedStates, serializedDiffs);
            AckClusterStatePublishResponseHandler publishResponseHandler = new AckClusterStatePublishResponseHandler(nodesToPublishTo, ackListener);
            sendingController = new SendingController(clusterChangedEvent.state(), minMasterNodes, totalMasterNodes, publishResponseHandler);
        }
        catch (Exception e) {
            throw new Discovery.FailedToCommitClusterStateException("unexpected error while preparing to publish", (Throwable)e, new Object[0]);
        }
        try {
            this.innerPublish(clusterChangedEvent, nodesToPublishTo, sendingController, sendFullVersion, serializedStates, serializedDiffs);
        }
        catch (Discovery.FailedToCommitClusterStateException t) {
            throw t;
        }
        catch (Exception e) {
            if (sendingController.markAsFailed("unexpected error", e)) {
                throw new Discovery.FailedToCommitClusterStateException("unexpected error", (Throwable)e, new Object[0]);
            }
            throw e;
        }
    }

    private void innerPublish(ClusterChangedEvent clusterChangedEvent, Set<DiscoveryNode> nodesToPublishTo, SendingController sendingController, boolean sendFullVersion, Map<Version, BytesReference> serializedStates, Map<Version, BytesReference> serializedDiffs) {
        ClusterState clusterState = clusterChangedEvent.state();
        ClusterState previousState = clusterChangedEvent.previousState();
        TimeValue publishTimeout = this.discoverySettings.getPublishTimeout();
        long publishingStartInNanos = System.nanoTime();
        for (DiscoveryNode node : nodesToPublishTo) {
            if (sendFullVersion || !previousState.nodes().nodeExists(node)) {
                this.sendFullClusterState(clusterState, serializedStates, node, publishTimeout, sendingController);
                continue;
            }
            this.sendClusterStateDiff(clusterState, serializedDiffs, serializedStates, node, publishTimeout, sendingController);
        }
        sendingController.waitForCommit(this.discoverySettings.getCommitTimeout());
        try {
            DiscoveryNode[] pendingNodes;
            long timeLeftInNanos = Math.max(0L, publishTimeout.nanos() - (System.nanoTime() - publishingStartInNanos));
            BlockingClusterStatePublishResponseHandler publishResponseHandler = sendingController.getPublishResponseHandler();
            sendingController.setPublishingTimedOut(!publishResponseHandler.awaitAllNodes(TimeValue.timeValueNanos(timeLeftInNanos)));
            if (sendingController.getPublishingTimedOut() && (pendingNodes = publishResponseHandler.pendingNodes()).length > 0) {
                this.logger.warn("timed out waiting for all nodes to process published state [{}] (timeout [{}], pending nodes: {})", (Object)clusterState.version(), (Object)publishTimeout, (Object)pendingNodes);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void buildDiffAndSerializeStates(ClusterState clusterState, ClusterState previousState, Set<DiscoveryNode> nodesToPublishTo, boolean sendFullVersion, Map<Version, BytesReference> serializedStates, Map<Version, BytesReference> serializedDiffs) {
        Diff<ClusterState> diff = null;
        for (DiscoveryNode node : nodesToPublishTo) {
            try {
                if (sendFullVersion || !previousState.nodes().nodeExists(node)) {
                    if (serializedStates.containsKey(node.getVersion())) continue;
                    serializedStates.put(node.getVersion(), PublishClusterStateAction.serializeFullClusterState(clusterState, node.getVersion()));
                    continue;
                }
                if (diff == null) {
                    diff = clusterState.diff(previousState);
                }
                if (serializedDiffs.containsKey(node.getVersion())) continue;
                serializedDiffs.put(node.getVersion(), PublishClusterStateAction.serializeDiffClusterState(diff, node.getVersion()));
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to serialize cluster_state for publishing to node {}", (Throwable)e, node);
            }
        }
    }

    private void sendFullClusterState(ClusterState clusterState, Map<Version, BytesReference> serializedStates, DiscoveryNode node, TimeValue publishTimeout, SendingController sendingController) {
        BytesReference bytes = serializedStates.get(node.getVersion());
        if (bytes == null) {
            try {
                bytes = PublishClusterStateAction.serializeFullClusterState(clusterState, node.getVersion());
                serializedStates.put(node.getVersion(), bytes);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("failed to serialize cluster_state before publishing it to node {}", (Object)node), (Throwable)e);
                sendingController.onNodeSendFailed(node, e);
                return;
            }
        }
        this.sendClusterStateToNode(clusterState, bytes, node, publishTimeout, sendingController, false, serializedStates);
    }

    private void sendClusterStateDiff(ClusterState clusterState, Map<Version, BytesReference> serializedDiffs, Map<Version, BytesReference> serializedStates, DiscoveryNode node, TimeValue publishTimeout, SendingController sendingController) {
        BytesReference bytes = serializedDiffs.get(node.getVersion());
        assert (bytes != null) : "failed to find serialized diff for node " + node + " of version [" + node.getVersion() + "]";
        this.sendClusterStateToNode(clusterState, bytes, node, publishTimeout, sendingController, true, serializedStates);
    }

    private void sendClusterStateToNode(final ClusterState clusterState, BytesReference bytes, final DiscoveryNode node, final TimeValue publishTimeout, final SendingController sendingController, final boolean sendDiffs, final Map<Version, BytesReference> serializedStates) {
        try {
            TransportRequestOptions options = TransportRequestOptions.builder().withType(TransportRequestOptions.Type.STATE).withCompress(false).build();
            this.transportService.sendRequest(node, SEND_ACTION_NAME, (TransportRequest)new BytesTransportRequest(bytes, node.getVersion()), options, new EmptyTransportResponseHandler("same"){

                @Override
                public void handleResponse(TransportResponse.Empty response) {
                    if (sendingController.getPublishingTimedOut()) {
                        PublishClusterStateAction.this.logger.debug("node {} responded for cluster state [{}] (took longer than [{}])", (Object)node, (Object)clusterState.version(), (Object)publishTimeout);
                    }
                    sendingController.onNodeSendAck(node);
                }

                @Override
                public void handleException(TransportException exp) {
                    if (sendDiffs && exp.unwrapCause() instanceof IncompatibleClusterStateVersionException) {
                        PublishClusterStateAction.this.logger.debug("resending full cluster state to node {} reason {}", (Object)node, (Object)exp.getDetailedMessage());
                        PublishClusterStateAction.this.sendFullClusterState(clusterState, serializedStates, node, publishTimeout, sendingController);
                    } else {
                        PublishClusterStateAction.this.logger.debug(() -> new ParameterizedMessage("failed to send cluster state to {}", (Object)node), (Throwable)exp);
                        sendingController.onNodeSendFailed(node, exp);
                    }
                }
            });
        }
        catch (Exception e) {
            this.logger.warn(() -> new ParameterizedMessage("error sending cluster state to {}", (Object)node), (Throwable)e);
            sendingController.onNodeSendFailed(node, e);
        }
    }

    private void sendCommitToNode(final DiscoveryNode node, final ClusterState clusterState, final SendingController sendingController) {
        try {
            this.logger.trace("sending commit for cluster state (uuid: [{}], version [{}]) to [{}]", (Object)clusterState.stateUUID(), (Object)clusterState.version(), (Object)node);
            TransportRequestOptions options = TransportRequestOptions.builder().withType(TransportRequestOptions.Type.STATE).build();
            this.transportService.sendRequest(node, COMMIT_ACTION_NAME, (TransportRequest)new CommitClusterStateRequest(clusterState.stateUUID()), options, new EmptyTransportResponseHandler("same"){

                @Override
                public void handleResponse(TransportResponse.Empty response) {
                    if (sendingController.getPublishingTimedOut()) {
                        PublishClusterStateAction.this.logger.debug("node {} responded to cluster state commit [{}]", (Object)node, (Object)clusterState.version());
                    }
                    sendingController.getPublishResponseHandler().onResponse(node);
                }

                @Override
                public void handleException(TransportException exp) {
                    PublishClusterStateAction.this.logger.debug(() -> new ParameterizedMessage("failed to commit cluster state (uuid [{}], version [{}]) to {}", clusterState.stateUUID(), clusterState.version(), node), (Throwable)exp);
                    sendingController.getPublishResponseHandler().onFailure(node, exp);
                }
            });
        }
        catch (Exception t) {
            this.logger.warn(() -> new ParameterizedMessage("error sending cluster state commit (uuid [{}], version [{}]) to {}", clusterState.stateUUID(), clusterState.version(), node), (Throwable)t);
            sendingController.getPublishResponseHandler().onFailure(node, t);
        }
    }

    public static BytesReference serializeFullClusterState(ClusterState clusterState, Version nodeVersion) throws IOException {
        BytesStreamOutput bStream = new BytesStreamOutput();
        try (StreamOutput stream = CompressorFactory.COMPRESSOR.streamOutput(bStream);){
            stream.setVersion(nodeVersion);
            stream.writeBoolean(true);
            clusterState.writeTo(stream);
        }
        return bStream.bytes();
    }

    public static BytesReference serializeDiffClusterState(Diff diff, Version nodeVersion) throws IOException {
        BytesStreamOutput bStream = new BytesStreamOutput();
        try (StreamOutput stream = CompressorFactory.COMPRESSOR.streamOutput(bStream);){
            stream.setVersion(nodeVersion);
            stream.writeBoolean(false);
            diff.writeTo(stream);
        }
        return bStream.bytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleIncomingClusterStateRequest(BytesTransportRequest request, TransportChannel channel) throws IOException {
        Compressor compressor = CompressorFactory.compressor(request.bytes());
        StreamInput in = request.bytes().streamInput();
        try {
            if (compressor != null) {
                in = compressor.streamInput(in);
            }
            in = new NamedWriteableAwareStreamInput(in, this.namedWriteableRegistry);
            in.setVersion(request.version());
            Object object = this.lastSeenClusterStateMutex;
            synchronized (object) {
                ClusterState incomingState;
                if (in.readBoolean()) {
                    incomingState = ClusterState.readFrom(in, this.clusterStateSupplier.get().nodes().getLocalNode());
                    this.logger.debug("received full cluster state version [{}] with size [{}]", (Object)incomingState.version(), (Object)request.bytes().length());
                } else if (this.lastSeenClusterState != null) {
                    Diff<ClusterState> diff = ClusterState.readDiffFrom(in, this.lastSeenClusterState.nodes().getLocalNode());
                    incomingState = diff.apply(this.lastSeenClusterState);
                    this.logger.debug("received diff cluster state version [{}] with uuid [{}], diff size [{}]", (Object)incomingState.version(), (Object)incomingState.stateUUID(), (Object)request.bytes().length());
                } else {
                    this.logger.debug("received diff for but don't have any local cluster state - requesting full state");
                    throw new IncompatibleClusterStateVersionException("have no local cluster state");
                }
                this.validateIncomingState(incomingState, this.lastSeenClusterState);
                this.pendingStatesQueue.addPending(incomingState);
                this.lastSeenClusterState = incomingState;
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close(in);
        channel.sendResponse(TransportResponse.Empty.INSTANCE);
    }

    void validateIncomingState(ClusterState incomingState, ClusterState lastSeenClusterState) {
        ClusterName incomingClusterName = incomingState.getClusterName();
        if (!incomingClusterName.equals(this.clusterName)) {
            this.logger.warn("received cluster state from [{}] which is also master but with a different cluster name [{}]", (Object)incomingState.nodes().getMasterNode(), (Object)incomingClusterName);
            throw new IllegalStateException("received state from a node that is not part of the cluster");
        }
        ClusterState clusterState = this.clusterStateSupplier.get();
        if (!clusterState.nodes().getLocalNode().equals(incomingState.nodes().getLocalNode())) {
            this.logger.warn("received a cluster state from [{}] and not part of the cluster, should not happen", (Object)incomingState.nodes().getMasterNode());
            throw new IllegalStateException("received state with a local node that does not match the current local node");
        }
        if (ZenDiscovery.shouldIgnoreOrRejectNewClusterState(this.logger, clusterState, incomingState)) {
            String message = String.format(Locale.ROOT, "rejecting cluster state version [%d] uuid [%s] received from [%s]", incomingState.version(), incomingState.stateUUID(), incomingState.nodes().getMasterNodeId());
            this.logger.warn(message);
            throw new IllegalStateException(message);
        }
    }

    protected void handleCommitRequest(CommitClusterStateRequest request, final TransportChannel channel) {
        ClusterState state = this.pendingStatesQueue.markAsCommitted(request.stateUUID, new PendingClusterStatesQueue.StateProcessedListener(){

            @Override
            public void onNewClusterStateProcessed() {
                try {
                    channel.sendResponse(TransportResponse.Empty.INSTANCE);
                }
                catch (Exception e) {
                    PublishClusterStateAction.this.logger.debug("failed to send response on cluster state processed", (Throwable)e);
                    this.onNewClusterStateFailed(e);
                }
            }

            @Override
            public void onNewClusterStateFailed(Exception e) {
                try {
                    channel.sendResponse(e);
                }
                catch (Exception inner) {
                    inner.addSuppressed(e);
                    PublishClusterStateAction.this.logger.debug("failed to send response on cluster state processed", (Throwable)inner);
                }
            }
        });
        if (state != null) {
            this.newPendingClusterStatelistener.onNewClusterState("master " + state.nodes().getMasterNode() + " committed version [" + state.version() + "]");
        }
    }

    class SendingController {
        private final ClusterState clusterState;
        private final BlockingClusterStatePublishResponseHandler publishResponseHandler;
        final ArrayList<DiscoveryNode> sendAckedBeforeCommit = new ArrayList();
        final CountDownLatch committedOrFailedLatch;
        boolean committed;
        int neededMastersToCommit;
        int pendingMasterNodes;
        final AtomicBoolean publishingTimedOut = new AtomicBoolean();

        public BlockingClusterStatePublishResponseHandler getPublishResponseHandler() {
            return this.publishResponseHandler;
        }

        private SendingController(ClusterState clusterState, int minMasterNodes, int totalMasterNodes, BlockingClusterStatePublishResponseHandler publishResponseHandler) {
            this.clusterState = clusterState;
            this.publishResponseHandler = publishResponseHandler;
            this.neededMastersToCommit = Math.max(0, minMasterNodes - 1);
            this.pendingMasterNodes = totalMasterNodes - 1;
            if (this.neededMastersToCommit > this.pendingMasterNodes) {
                throw new Discovery.FailedToCommitClusterStateException("not enough masters to ack sent cluster state.[{}] needed , have [{}]", this.neededMastersToCommit, this.pendingMasterNodes);
            }
            this.committed = this.neededMastersToCommit == 0;
            this.committedOrFailedLatch = new CountDownLatch(this.committed ? 0 : 1);
        }

        public void waitForCommit(TimeValue commitTimeout) {
            boolean timedout = false;
            try {
                timedout = !this.committedOrFailedLatch.await(commitTimeout.millis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (timedout) {
                this.markAsFailed("timed out waiting for commit (commit timeout [" + commitTimeout + "])");
            }
            if (!this.isCommitted()) {
                throw new Discovery.FailedToCommitClusterStateException("{} enough masters to ack sent cluster state. [{}] left", timedout ? "timed out while waiting for" : "failed to get", this.neededMastersToCommit);
            }
        }

        public synchronized boolean isCommitted() {
            return this.committed;
        }

        public synchronized void onNodeSendAck(DiscoveryNode node) {
            if (this.committed) {
                assert (this.sendAckedBeforeCommit.isEmpty());
                PublishClusterStateAction.this.sendCommitToNode(node, this.clusterState, this);
            } else if (this.committedOrFailed()) {
                PublishClusterStateAction.this.logger.trace("ignoring ack from [{}] for cluster state version [{}]. already failed", (Object)node, (Object)this.clusterState.version());
            } else {
                this.sendAckedBeforeCommit.add(node);
                if (node.isMasterNode()) {
                    this.checkForCommitOrFailIfNoPending(node);
                }
            }
        }

        private synchronized boolean committedOrFailed() {
            return this.committedOrFailedLatch.getCount() == 0L;
        }

        private synchronized void checkForCommitOrFailIfNoPending(DiscoveryNode masterNode) {
            PublishClusterStateAction.this.logger.trace("master node {} acked cluster state version [{}]. processing ... (current pending [{}], needed [{}])", (Object)masterNode, (Object)this.clusterState.version(), (Object)this.pendingMasterNodes, (Object)this.neededMastersToCommit);
            --this.neededMastersToCommit;
            if (this.neededMastersToCommit == 0 && this.markAsCommitted()) {
                for (DiscoveryNode nodeToCommit : this.sendAckedBeforeCommit) {
                    PublishClusterStateAction.this.sendCommitToNode(nodeToCommit, this.clusterState, this);
                }
                this.sendAckedBeforeCommit.clear();
            }
            this.decrementPendingMasterAcksAndChangeForFailure();
        }

        private synchronized void decrementPendingMasterAcksAndChangeForFailure() {
            --this.pendingMasterNodes;
            if (this.pendingMasterNodes == 0 && this.neededMastersToCommit > 0) {
                this.markAsFailed("no more pending master nodes, but failed to reach needed acks ([" + this.neededMastersToCommit + "] left)");
            }
        }

        public synchronized void onNodeSendFailed(DiscoveryNode node, Exception e) {
            if (node.isMasterNode()) {
                PublishClusterStateAction.this.logger.trace("master node {} failed to ack cluster state version [{}]. processing ... (current pending [{}], needed [{}])", (Object)node, (Object)this.clusterState.version(), (Object)this.pendingMasterNodes, (Object)this.neededMastersToCommit);
                this.decrementPendingMasterAcksAndChangeForFailure();
            }
            this.publishResponseHandler.onFailure(node, e);
        }

        private synchronized boolean markAsCommitted() {
            if (this.committedOrFailed()) {
                return this.committed;
            }
            PublishClusterStateAction.this.logger.trace("committing version [{}]", (Object)this.clusterState.version());
            this.committed = true;
            this.committedOrFailedLatch.countDown();
            return true;
        }

        private synchronized boolean markAsFailed(String details, Exception reason) {
            if (this.committedOrFailed()) {
                return !this.committed;
            }
            PublishClusterStateAction.this.logger.trace(() -> new ParameterizedMessage("failed to commit version [{}]. {}", (Object)this.clusterState.version(), (Object)details), (Throwable)reason);
            this.committed = false;
            this.committedOrFailedLatch.countDown();
            return true;
        }

        private synchronized boolean markAsFailed(String reason) {
            if (this.committedOrFailed()) {
                return !this.committed;
            }
            PublishClusterStateAction.this.logger.trace("failed to commit version [{}]. {}", (Object)this.clusterState.version(), (Object)reason);
            this.committed = false;
            this.committedOrFailedLatch.countDown();
            return true;
        }

        public boolean getPublishingTimedOut() {
            return this.publishingTimedOut.get();
        }

        public void setPublishingTimedOut(boolean isTimedOut) {
            this.publishingTimedOut.set(isTimedOut);
        }
    }

    protected static class CommitClusterStateRequest
    extends TransportRequest {
        String stateUUID;

        public CommitClusterStateRequest() {
        }

        public CommitClusterStateRequest(String stateUUID) {
            this.stateUUID = stateUUID;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.stateUUID = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.stateUUID);
        }
    }

    private class CommitClusterStateRequestHandler
    implements TransportRequestHandler<CommitClusterStateRequest> {
        private CommitClusterStateRequestHandler() {
        }

        @Override
        public void messageReceived(CommitClusterStateRequest request, TransportChannel channel) throws Exception {
            PublishClusterStateAction.this.handleCommitRequest(request, channel);
        }
    }

    private class SendClusterStateRequestHandler
    implements TransportRequestHandler<BytesTransportRequest> {
        private SendClusterStateRequestHandler() {
        }

        @Override
        public void messageReceived(BytesTransportRequest request, TransportChannel channel) throws Exception {
            PublishClusterStateAction.this.handleIncomingClusterStateRequest(request, channel);
        }
    }

    public static interface NewPendingClusterStateListener {
        public void onNewClusterState(String var1);
    }
}

