/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.gateway;

import java.io.IOException;
import java.util.List;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.FailedNodeException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterName;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.NodeEnvironment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.gateway.AsyncShardFetch;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.ShardId;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.ShardPath;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.ShardStateMetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.store.Store;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.IndicesService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportService;

public class TransportNodesListGatewayStartedShards
extends TransportNodesAction<Request, NodesGatewayStartedShards, NodeRequest, NodeGatewayStartedShards>
implements AsyncShardFetch.Lister<NodesGatewayStartedShards, NodeGatewayStartedShards> {
    public static final String ACTION_NAME = "internal:gateway/local/started_shards";
    private final NodeEnvironment nodeEnv;
    private final IndicesService indicesService;

    @Inject
    public TransportNodesListGatewayStartedShards(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NodeEnvironment env, IndicesService indicesService) {
        super(settings, ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request::new, NodeRequest::new, "fetch_shard_started", NodeGatewayStartedShards.class);
        this.nodeEnv = env;
        this.indicesService = indicesService;
    }

    @Override
    public void list(ShardId shardId, DiscoveryNode[] nodes, ActionListener<NodesGatewayStartedShards> listener) {
        this.execute(new Request(shardId, nodes), listener);
    }

    @Override
    protected boolean transportCompress() {
        return true;
    }

    @Override
    protected NodeRequest newNodeRequest(String nodeId, Request request) {
        return new NodeRequest(nodeId, request);
    }

    @Override
    protected NodeGatewayStartedShards newNodeResponse() {
        return new NodeGatewayStartedShards();
    }

    @Override
    protected NodesGatewayStartedShards newResponse(Request request, List<NodeGatewayStartedShards> responses, List<FailedNodeException> failures) {
        return new NodesGatewayStartedShards(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeGatewayStartedShards nodeOperation(NodeRequest request) {
        try {
            ShardId shardId = request.getShardId();
            this.logger.trace("{} loading local shard state info", (Object)shardId);
            ShardStateMetaData shardStateMetaData = ShardStateMetaData.FORMAT.loadLatestState(this.logger, NamedXContentRegistry.EMPTY, this.nodeEnv.availableShardPaths(request.shardId));
            if (shardStateMetaData != null) {
                IndexMetaData metaData = this.clusterService.state().metaData().index(shardId.getIndex());
                if (metaData == null) {
                    metaData = IndexMetaData.FORMAT.loadLatestState(this.logger, NamedXContentRegistry.EMPTY, this.nodeEnv.indexPaths(shardId.getIndex()));
                }
                if (metaData == null) {
                    ElasticsearchException e = new ElasticsearchException("failed to find local IndexMetaData", new Object[0]);
                    e.setShard(request.shardId);
                    throw e;
                }
                if (this.indicesService.getShardOrNull(shardId) == null) {
                    ShardPath shardPath = null;
                    try {
                        IndexSettings indexSettings = new IndexSettings(metaData, this.settings);
                        shardPath = ShardPath.loadShardPath(this.logger, this.nodeEnv, shardId, indexSettings);
                        if (shardPath == null) {
                            throw new IllegalStateException(shardId + " no shard path found");
                        }
                        Store.tryOpenIndex(shardPath.resolveIndex(), shardId, this.nodeEnv::shardLock, this.logger);
                    }
                    catch (Exception exception) {
                        ShardPath finalShardPath = shardPath;
                        this.logger.trace(() -> new ParameterizedMessage("{} can't open index for shard [{}] in path [{}]", shardId, shardStateMetaData, finalShardPath != null ? finalShardPath.resolveIndex() : ""), (Throwable)exception);
                        String allocationId = shardStateMetaData.allocationId != null ? shardStateMetaData.allocationId.getId() : null;
                        return new NodeGatewayStartedShards(this.clusterService.localNode(), shardStateMetaData.legacyVersion, allocationId, shardStateMetaData.primary, exception);
                    }
                }
                this.logger.debug("{} shard state info found: [{}]", (Object)shardId, (Object)shardStateMetaData);
                String allocationId = shardStateMetaData.allocationId != null ? shardStateMetaData.allocationId.getId() : null;
                return new NodeGatewayStartedShards(this.clusterService.localNode(), shardStateMetaData.legacyVersion, allocationId, shardStateMetaData.primary);
            }
            this.logger.trace("{} no local shard info found", (Object)shardId);
            return new NodeGatewayStartedShards(this.clusterService.localNode(), -1L, null, false);
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to load started shards", (Throwable)e, new Object[0]);
        }
    }

    public static class NodeGatewayStartedShards
    extends BaseNodeResponse {
        private long legacyVersion = -1L;
        private String allocationId = null;
        private boolean primary = false;
        private Exception storeException = null;

        public NodeGatewayStartedShards() {
        }

        public NodeGatewayStartedShards(DiscoveryNode node, long legacyVersion, String allocationId, boolean primary) {
            this(node, legacyVersion, allocationId, primary, null);
        }

        public NodeGatewayStartedShards(DiscoveryNode node, long legacyVersion, String allocationId, boolean primary, Exception storeException) {
            super(node);
            this.legacyVersion = legacyVersion;
            this.allocationId = allocationId;
            this.primary = primary;
            this.storeException = storeException;
        }

        public long legacyVersion() {
            return this.legacyVersion;
        }

        public String allocationId() {
            return this.allocationId;
        }

        public boolean primary() {
            return this.primary;
        }

        public Exception storeException() {
            return this.storeException;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.legacyVersion = in.readLong();
            this.allocationId = in.readOptionalString();
            this.primary = in.readBoolean();
            if (in.readBoolean()) {
                this.storeException = in.readException();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeLong(this.legacyVersion);
            out.writeOptionalString(this.allocationId);
            out.writeBoolean(this.primary);
            if (this.storeException != null) {
                out.writeBoolean(true);
                out.writeException(this.storeException);
            } else {
                out.writeBoolean(false);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeGatewayStartedShards that = (NodeGatewayStartedShards)o;
            if (this.legacyVersion != that.legacyVersion) {
                return false;
            }
            if (this.primary != that.primary) {
                return false;
            }
            if (this.allocationId != null ? !this.allocationId.equals(that.allocationId) : that.allocationId != null) {
                return false;
            }
            return this.storeException != null ? this.storeException.equals(that.storeException) : that.storeException == null;
        }

        public int hashCode() {
            int result = Long.hashCode(this.legacyVersion);
            result = 31 * result + (this.allocationId != null ? this.allocationId.hashCode() : 0);
            result = 31 * result + (this.primary ? 1 : 0);
            result = 31 * result + (this.storeException != null ? this.storeException.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("NodeGatewayStartedShards[").append("allocationId=").append(this.allocationId).append(",primary=").append(this.primary).append(",legacyVersion=").append(this.legacyVersion);
            if (this.storeException != null) {
                buf.append(",storeException=").append(this.storeException);
            }
            buf.append("]");
            return buf.toString();
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        private ShardId shardId;

        public NodeRequest() {
        }

        public NodeRequest(String nodeId, Request request) {
            super(nodeId);
            this.shardId = request.shardId();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = ShardId.readShardId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
        }

        public ShardId getShardId() {
            return this.shardId;
        }
    }

    public static class NodesGatewayStartedShards
    extends BaseNodesResponse<NodeGatewayStartedShards> {
        public NodesGatewayStartedShards(ClusterName clusterName, List<NodeGatewayStartedShards> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        @Override
        protected List<NodeGatewayStartedShards> readNodesFrom(StreamInput in) throws IOException {
            return in.readStreamableList(NodeGatewayStartedShards::new);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeGatewayStartedShards> nodes) throws IOException {
            out.writeStreamableList(nodes);
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private ShardId shardId;

        public Request() {
        }

        public Request(ShardId shardId, DiscoveryNode[] nodes) {
            super(nodes);
            this.shardId = shardId;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = ShardId.readShardId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
        }
    }
}

