/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DirectoryReader;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.AbstractComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.engine.Engine;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.DocumentMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.FieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MapperService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.IndexShard;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.IndexShardState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;

public final class IndexWarmer
extends AbstractComponent {
    private final List<Listener> listeners;

    IndexWarmer(Settings settings, ThreadPool threadPool, Listener ... listeners) {
        super(settings);
        ArrayList<FieldDataWarmer> list = new ArrayList<FieldDataWarmer>();
        ExecutorService executor = threadPool.executor("warmer");
        list.add(new FieldDataWarmer(executor));
        Collections.addAll(list, listeners);
        this.listeners = Collections.unmodifiableList(list);
    }

    void warm(Engine.Searcher searcher, IndexShard shard, IndexSettings settings) {
        if (shard.state() == IndexShardState.CLOSED) {
            return;
        }
        if (!settings.isWarmerEnabled()) {
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("{} top warming [{}]", (Object)shard.shardId(), (Object)searcher.reader());
        }
        shard.warmerService().onPreWarm();
        long time = System.nanoTime();
        ArrayList<TerminationHandle> terminationHandles = new ArrayList<TerminationHandle>();
        for (Listener listener : this.listeners) {
            terminationHandles.add(listener.warmReader(shard, searcher));
        }
        for (TerminationHandle terminationHandle : terminationHandles) {
            try {
                terminationHandle.awaitTermination();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.warn("top warming has been interrupted", (Throwable)e);
                break;
            }
        }
        long took = System.nanoTime() - time;
        shard.warmerService().onPostWarm(took);
        if (shard.warmerService().logger().isTraceEnabled()) {
            shard.warmerService().logger().trace("top warming took [{}]", (Object)new TimeValue(took, TimeUnit.NANOSECONDS));
        }
    }

    private static class FieldDataWarmer
    implements Listener {
        private final Executor executor;

        FieldDataWarmer(Executor executor) {
            this.executor = executor;
        }

        @Override
        public TerminationHandle warmReader(IndexShard indexShard, Engine.Searcher searcher) {
            MapperService mapperService = indexShard.mapperService();
            HashMap<String, MappedFieldType> warmUpGlobalOrdinals = new HashMap<String, MappedFieldType>();
            for (DocumentMapper docMapper : mapperService.docMappers(false)) {
                for (FieldMapper fieldMapper : docMapper.mappers()) {
                    MappedFieldType fieldType = fieldMapper.fieldType();
                    String indexName = fieldType.name();
                    if (!fieldType.eagerGlobalOrdinals()) continue;
                    warmUpGlobalOrdinals.put(indexName, fieldType);
                }
            }
            IndexFieldDataService indexFieldDataService = indexShard.indexFieldDataService();
            CountDownLatch latch = new CountDownLatch(warmUpGlobalOrdinals.size());
            for (MappedFieldType fieldType : warmUpGlobalOrdinals.values()) {
                this.executor.execute(() -> {
                    try {
                        long start = System.nanoTime();
                        IndexFieldData.Global ifd = (IndexFieldData.Global)indexFieldDataService.getForField(fieldType);
                        DirectoryReader reader = searcher.getDirectoryReader();
                        IndexFieldData global = ifd.loadGlobal(reader);
                        if (!reader.leaves().isEmpty()) {
                            global.load(reader.leaves().get(0));
                        }
                        if (indexShard.warmerService().logger().isTraceEnabled()) {
                            indexShard.warmerService().logger().trace("warmed global ordinals for [{}], took [{}]", (Object)fieldType.name(), (Object)TimeValue.timeValueNanos(System.nanoTime() - start));
                        }
                    }
                    catch (Exception e) {
                        indexShard.warmerService().logger().warn(() -> new ParameterizedMessage("failed to warm-up global ordinals for [{}]", (Object)fieldType.name()), (Throwable)e);
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            return () -> latch.await();
        }
    }

    public static interface Listener {
        public TerminationHandle warmReader(IndexShard var1, Engine.Searcher var2);
    }

    public static interface TerminationHandle {
        public static final TerminationHandle NO_WAIT = () -> {};

        public void awaitTermination() throws InterruptedException;
    }
}

