/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.Tokenizer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.CharMatcher;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.NGramTokenizerFactory;

public class EdgeNGramTokenizerFactory
extends AbstractTokenizerFactory {
    private final int minGram;
    private final int maxGram;
    private final CharMatcher matcher;

    public EdgeNGramTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.minGram = settings.getAsInt("min_gram", 1);
        this.maxGram = settings.getAsInt("max_gram", 2);
        this.matcher = NGramTokenizerFactory.parseTokenChars(settings.getAsArray("token_chars"));
    }

    @Override
    public Tokenizer create() {
        if (this.matcher == null) {
            return new EdgeNGramTokenizer(this.minGram, this.maxGram);
        }
        return new EdgeNGramTokenizer(this.minGram, this.maxGram){

            @Override
            protected boolean isTokenChar(int chr) {
                return EdgeNGramTokenizerFactory.this.matcher.isTokenChar(chr);
            }
        };
    }
}

