/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis;

import java.util.regex.Pattern;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.Tokenizer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.pattern.PatternTokenizer;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.regex.Regex;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AbstractTokenizerFactory;

public class PatternTokenizerFactory
extends AbstractTokenizerFactory {
    private final Pattern pattern;
    private final int group;

    public PatternTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        String sPattern = settings.get("pattern", "\\W+");
        if (sPattern == null) {
            throw new IllegalArgumentException("pattern is missing for [" + name + "] tokenizer of type 'pattern'");
        }
        this.pattern = Regex.compile(sPattern, settings.get("flags"));
        this.group = settings.getAsInt("group", -1);
    }

    @Override
    public Tokenizer create() {
        return new PatternTokenizer(this.pattern, this.group);
    }
}

