/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.SearcherManager;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.AlreadyClosedException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.engine.Engine;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.store.Store;

public class EngineSearcher
extends Engine.Searcher {
    private final SearcherManager manager;
    private final AtomicBoolean released = new AtomicBoolean(false);
    private final Store store;
    private final Logger logger;

    public EngineSearcher(String source, IndexSearcher searcher, SearcherManager manager, Store store, Logger logger) {
        super(source, searcher);
        this.manager = manager;
        this.store = store;
        this.logger = logger;
    }

    @Override
    public void close() {
        if (!this.released.compareAndSet(false, true)) {
            this.logger.warn("Searcher was released twice", (Throwable)new IllegalStateException("Double release"));
            return;
        }
        try {
            this.manager.release(this.searcher());
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot close", e);
        }
        catch (AlreadyClosedException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            this.store.decRef();
        }
    }
}

