/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.ordinals;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MultiDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.RandomAccessOrds;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedSetDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Accountable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.ScriptDocValues;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsIndexFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.plain.AbstractAtomicOrdinalsFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.breaker.CircuitBreakerService;

public final class GlobalOrdinalsBuilder
extends Enum<GlobalOrdinalsBuilder> {
    private static final /* synthetic */ GlobalOrdinalsBuilder[] $VALUES;

    public static GlobalOrdinalsBuilder[] values() {
        return (GlobalOrdinalsBuilder[])$VALUES.clone();
    }

    public static GlobalOrdinalsBuilder valueOf(String name) {
        return Enum.valueOf(GlobalOrdinalsBuilder.class, name);
    }

    public static IndexOrdinalsFieldData build(IndexReader indexReader, IndexOrdinalsFieldData indexFieldData, IndexSettings indexSettings, CircuitBreakerService breakerService, Logger logger, Function<RandomAccessOrds, ScriptDocValues<?>> scriptFunction) throws IOException {
        assert (indexReader.leaves().size() > 1);
        long startTimeNS = System.nanoTime();
        AtomicOrdinalsFieldData[] atomicFD = new AtomicOrdinalsFieldData[indexReader.leaves().size()];
        SortedSetDocValues[] subs = new RandomAccessOrds[indexReader.leaves().size()];
        for (int i = 0; i < indexReader.leaves().size(); ++i) {
            atomicFD[i] = (AtomicOrdinalsFieldData)indexFieldData.load(indexReader.leaves().get(i));
            subs[i] = atomicFD[i].getOrdinalsValues();
        }
        MultiDocValues.OrdinalMap ordinalMap = MultiDocValues.OrdinalMap.build(null, subs, 0.25f);
        long memorySizeInBytes = ordinalMap.ramBytesUsed();
        breakerService.getBreaker("fielddata").addWithoutBreaking(memorySizeInBytes);
        if (logger.isDebugEnabled()) {
            logger.debug("global-ordinals [{}][{}] took [{}]", (Object)indexFieldData.getFieldName(), (Object)ordinalMap.getValueCount(), (Object)new TimeValue(System.nanoTime() - startTimeNS, TimeUnit.NANOSECONDS));
        }
        return new GlobalOrdinalsIndexFieldData(indexSettings, indexFieldData.getFieldName(), atomicFD, ordinalMap, memorySizeInBytes, scriptFunction);
    }

    public static IndexOrdinalsFieldData buildEmpty(IndexSettings indexSettings, IndexReader indexReader, IndexOrdinalsFieldData indexFieldData) throws IOException {
        assert (indexReader.leaves().size() > 1);
        AtomicOrdinalsFieldData[] atomicFD = new AtomicOrdinalsFieldData[indexReader.leaves().size()];
        SortedSetDocValues[] subs = new RandomAccessOrds[indexReader.leaves().size()];
        for (int i = 0; i < indexReader.leaves().size(); ++i) {
            atomicFD[i] = new AbstractAtomicOrdinalsFieldData((Function)AbstractAtomicOrdinalsFieldData.DEFAULT_SCRIPT_FUNCTION){

                @Override
                public RandomAccessOrds getOrdinalsValues() {
                    return DocValues.emptySortedSet();
                }

                @Override
                public long ramBytesUsed() {
                    return 0L;
                }

                @Override
                public Collection<Accountable> getChildResources() {
                    return Collections.emptyList();
                }

                @Override
                public void close() {
                }
            };
            subs[i] = atomicFD[i].getOrdinalsValues();
        }
        MultiDocValues.OrdinalMap ordinalMap = MultiDocValues.OrdinalMap.build(null, subs, 0.25f);
        return new GlobalOrdinalsIndexFieldData(indexSettings, indexFieldData.getFieldName(), atomicFD, ordinalMap, 0L, AbstractAtomicOrdinalsFieldData.DEFAULT_SCRIPT_FUNCTION);
    }

    static {
        $VALUES = new GlobalOrdinalsBuilder[0];
    }
}

