/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.LongPoint;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.SortedNumericDocValuesField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.StoredField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MultiFields;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.PointValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BoostQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.IndexOrDocValuesQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.fieldstats.FieldStats;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Explicit;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.joda.DateMathParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.joda.Joda;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.LocaleUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.FieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.LegacyDateFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.LegacyNumberFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.Mapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MapperParsingException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.ParseContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.TypeParsers;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryRewriteContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch5.org.joda.time.DateTimeZone;

public class DateFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "date";
    public static final FormatDateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = Joda.forPattern("strict_date_optional_time||epoch_millis", Locale.ROOT);
    private Boolean includeInAll;
    private Explicit<Boolean> ignoreMalformed;

    private DateFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Boolean includeInAll, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
        this.includeInAll = includeInAll;
    }

    @Override
    public DateFieldType fieldType() {
        return (DateFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType.typeName();
    }

    @Override
    protected DateFieldMapper clone() {
        return (DateFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        long timestamp;
        Object dateAsObject;
        Object dateAsString = context.externalValueSet() ? ((dateAsObject = context.externalValue()) == null ? null : dateAsObject.toString()) : context.parser().textOrNull();
        if (dateAsString == null) {
            dateAsString = this.fieldType().nullValueAsString();
        }
        if (dateAsString == null) {
            return;
        }
        try {
            timestamp = this.fieldType().parse((String)dateAsString);
        }
        catch (IllegalArgumentException e) {
            if (this.ignoreMalformed.value().booleanValue()) {
                return;
            }
            throw e;
        }
        if (context.includeInAll(this.includeInAll, this)) {
            context.allEntries().addText(this.fieldType().name(), (String)dateAsString, this.fieldType().boost());
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE) {
            fields.add(new LongPoint(this.fieldType().name(), timestamp));
        }
        if (this.fieldType().hasDocValues()) {
            fields.add(new SortedNumericDocValuesField(this.fieldType().name(), timestamp));
        }
        if (this.fieldType().stored()) {
            fields.add(new StoredField(this.fieldType().name(), timestamp));
        }
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        DateFieldMapper other = (DateFieldMapper)mergeWith;
        this.includeInAll = other.includeInAll;
        if (other.ignoreMalformed.explicit()) {
            this.ignoreMalformed = other.ignoreMalformed;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", this.ignoreMalformed.value());
        }
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field("null_value", this.fieldType().nullValueAsString());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
        if (includeDefaults || !this.fieldType().dateTimeFormatter().format().equals(DEFAULT_DATE_TIME_FORMATTER.format())) {
            builder.field("format", this.fieldType().dateTimeFormatter().format());
        }
        if (includeDefaults || this.fieldType().dateTimeFormatter().locale() != Locale.ROOT) {
            builder.field("locale", this.fieldType().dateTimeFormatter().locale());
        }
    }

    public static final class DateFieldType
    extends MappedFieldType {
        protected FormatDateTimeFormatter dateTimeFormatter;
        protected DateMathParser dateMathParser;

        DateFieldType() {
            this.setTokenized(false);
            this.setHasDocValues(true);
            this.setOmitNorms(true);
            this.setDateTimeFormatter(DEFAULT_DATE_TIME_FORMATTER);
        }

        DateFieldType(DateFieldType other) {
            super(other);
            this.setDateTimeFormatter(other.dateTimeFormatter);
        }

        @Override
        public MappedFieldType clone() {
            return new DateFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            DateFieldType that = (DateFieldType)o;
            return Objects.equals(this.dateTimeFormatter.format(), that.dateTimeFormatter.format()) && Objects.equals(this.dateTimeFormatter.locale(), that.dateTimeFormatter.locale());
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.dateTimeFormatter.format(), this.dateTimeFormatter.locale());
        }

        @Override
        public String typeName() {
            return DateFieldMapper.CONTENT_TYPE;
        }

        @Override
        public void checkCompatibility(MappedFieldType fieldType, List<String> conflicts, boolean strict) {
            super.checkCompatibility(fieldType, conflicts, strict);
            DateFieldType other = (DateFieldType)fieldType;
            if (!Objects.equals(this.dateTimeFormatter().format(), other.dateTimeFormatter().format())) {
                conflicts.add("mapper [" + this.name() + "] has different [format] values");
            }
            if (!Objects.equals(this.dateTimeFormatter().locale(), other.dateTimeFormatter().locale())) {
                conflicts.add("mapper [" + this.name() + "] has different [locale] values");
            }
        }

        public FormatDateTimeFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        public void setDateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.checkIfFrozen();
            this.dateTimeFormatter = dateTimeFormatter;
            this.dateMathParser = new DateMathParser(dateTimeFormatter);
        }

        protected DateMathParser dateMathParser() {
            return this.dateMathParser;
        }

        long parse(String value) {
            return this.dateTimeFormatter().parser().parseMillis(value);
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            Query query = this.innerRangeQuery(value, value, true, true, null, null, context);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            this.failIfNotIndexed();
            return this.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, null, null, context);
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable DateTimeZone timeZone, @Nullable DateMathParser forcedDateParser, QueryShardContext context) {
            this.failIfNotIndexed();
            return this.innerRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, timeZone, forcedDateParser, context);
        }

        Query innerRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable DateTimeZone timeZone, @Nullable DateMathParser forcedDateParser, QueryShardContext context) {
            long u;
            long l;
            DateMathParser parser;
            this.failIfNotIndexed();
            DateMathParser dateMathParser = parser = forcedDateParser == null ? this.dateMathParser : forcedDateParser;
            if (lowerTerm == null) {
                l = Long.MIN_VALUE;
            } else {
                l = this.parseToMilliseconds(lowerTerm, !includeLower, timeZone, parser, context);
                if (!includeLower) {
                    ++l;
                }
            }
            if (upperTerm == null) {
                u = Long.MAX_VALUE;
            } else {
                u = this.parseToMilliseconds(upperTerm, includeUpper, timeZone, parser, context);
                if (!includeUpper) {
                    --u;
                }
            }
            Query query = LongPoint.newRangeQuery(this.name(), l, u);
            if (this.hasDocValues()) {
                Query dvQuery = SortedNumericDocValuesField.newRangeQuery(this.name(), l, u);
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }

        public long parseToMilliseconds(Object value, boolean roundUp, @Nullable DateTimeZone zone, @Nullable DateMathParser forcedDateParser, QueryRewriteContext context) {
            DateMathParser dateParser = this.dateMathParser();
            if (forcedDateParser != null) {
                dateParser = forcedDateParser;
            }
            String strValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            return dateParser.parse(strValue, context::nowInMillis, roundUp, zone);
        }

        @Override
        public FieldStats.Date stats(IndexReader reader) throws IOException {
            String field = this.name();
            FieldInfo fi = MultiFields.getMergedFieldInfos(reader).fieldInfo(this.name());
            if (fi == null) {
                return null;
            }
            long size = PointValues.size(reader, field);
            if (size == 0L) {
                return new FieldStats.Date(reader.maxDoc(), 0L, -1L, -1L, this.isSearchable(), this.isAggregatable());
            }
            int docCount = PointValues.getDocCount(reader, field);
            byte[] min = PointValues.getMinPackedValue(reader, field);
            byte[] max = PointValues.getMaxPackedValue(reader, field);
            return new FieldStats.Date(reader.maxDoc(), (long)docCount, -1L, size, this.isSearchable(), this.isAggregatable(), this.dateTimeFormatter(), LongPoint.decodeDimension(min, 0), LongPoint.decodeDimension(max, 0));
        }

        @Override
        public MappedFieldType.Relation isFieldWithinQuery(IndexReader reader, Object from, Object to, boolean includeLower, boolean includeUpper, DateTimeZone timeZone, DateMathParser dateParser, QueryRewriteContext context) throws IOException {
            if (dateParser == null) {
                dateParser = this.dateMathParser;
            }
            long fromInclusive = Long.MIN_VALUE;
            if (from != null) {
                fromInclusive = this.parseToMilliseconds(from, !includeLower, timeZone, dateParser, context);
                if (!includeLower) {
                    if (fromInclusive == Long.MAX_VALUE) {
                        return MappedFieldType.Relation.DISJOINT;
                    }
                    ++fromInclusive;
                }
            }
            long toInclusive = Long.MAX_VALUE;
            if (to != null) {
                toInclusive = this.parseToMilliseconds(to, includeUpper, timeZone, dateParser, context);
                if (!includeUpper) {
                    if (toInclusive == Long.MIN_VALUE) {
                        return MappedFieldType.Relation.DISJOINT;
                    }
                    --toInclusive;
                }
            }
            if (PointValues.size(reader, this.name()) == 0L) {
                return MappedFieldType.Relation.DISJOINT;
            }
            long minValue = LongPoint.decodeDimension(PointValues.getMinPackedValue(reader, this.name()), 0);
            long maxValue = LongPoint.decodeDimension(PointValues.getMaxPackedValue(reader, this.name()), 0);
            if (minValue >= fromInclusive && maxValue <= toInclusive) {
                return MappedFieldType.Relation.WITHIN;
            }
            if (maxValue < fromInclusive || minValue > toInclusive) {
                return MappedFieldType.Relation.DISJOINT;
            }
            return MappedFieldType.Relation.INTERSECTS;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            this.failIfNoDocValues();
            return new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.LONG);
        }

        @Override
        public Object valueForDisplay(Object value) {
            Long val = (Long)value;
            if (val == null) {
                return null;
            }
            return this.dateTimeFormatter().printer().print(val);
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, DateTimeZone timeZone) {
            FormatDateTimeFormatter dateTimeFormatter = this.dateTimeFormatter;
            if (format != null) {
                dateTimeFormatter = Joda.forPattern(format);
            }
            if (timeZone == null) {
                timeZone = DateTimeZone.UTC;
            }
            return new DocValueFormat.DateTime(dateTimeFormatter, timeZone);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            if (parserContext.indexVersionCreated().before(Version.V_5_0_0_alpha2)) {
                return new LegacyDateFieldMapper.TypeParser().parse(name, node, parserContext);
            }
            Builder builder = new Builder(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    builder.nullValue(propNode.toString());
                    iterator.remove();
                    continue;
                }
                if (propName.equals("ignore_malformed")) {
                    builder.ignoreMalformed(TypeParsers.nodeBooleanValue(name, "ignore_malformed", propNode));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("locale")) {
                    builder.locale(LocaleUtils.parse(propNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("format")) {
                    builder.dateTimeFormatter(TypeParsers.parseDateTimeFormatter(propNode));
                    iterator.remove();
                    continue;
                }
                if (!TypeParsers.parseMultiField(builder, name, parserContext, propName, propNode)) continue;
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, DateFieldMapper> {
        private Boolean ignoreMalformed;
        private Locale locale;
        private boolean dateTimeFormatterSet = false;

        public Builder(String name) {
            super(name, new DateFieldType(), new DateFieldType());
            this.builder = this;
            this.locale = Locale.ROOT;
        }

        @Override
        public DateFieldType fieldType() {
            return (DateFieldType)this.fieldType;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return LegacyNumberFieldMapper.Defaults.IGNORE_MALFORMED;
        }

        public boolean isDateTimeFormatterSet() {
            return this.dateTimeFormatterSet;
        }

        public Builder dateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.fieldType().setDateTimeFormatter(dateTimeFormatter);
            this.dateTimeFormatterSet = true;
            return this;
        }

        public void locale(Locale locale) {
            this.locale = locale;
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            super.setupFieldType(context);
            FormatDateTimeFormatter dateTimeFormatter = this.fieldType().dateTimeFormatter;
            if (!this.locale.equals(dateTimeFormatter.locale())) {
                this.fieldType().setDateTimeFormatter(new FormatDateTimeFormatter(dateTimeFormatter.format(), dateTimeFormatter.parser(), dateTimeFormatter.printer(), this.locale));
            }
        }

        @Override
        public DateFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new DateFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), this.includeInAll, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }
}

