/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.search;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.miscellaneous.DisableGraphAttribute;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Term;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.ExtendedCommonTermsQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BooleanClause;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BooleanQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BoostQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.FuzzyQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.MultiPhraseQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.MultiTermQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.PhraseQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.PrefixQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.SynonymQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.TermQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.SpanNearQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.SpanOrQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.SpanQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.SpanTermQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.QueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.all.AllTermQuery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.search.Queries;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.Fuzziness;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.NamedAnalyzer;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.support.QueryParsers;

public class MatchQuery {
    public static final int DEFAULT_PHRASE_SLOP = 0;
    public static final boolean DEFAULT_LENIENCY = false;
    public static final ZeroTermsQuery DEFAULT_ZERO_TERMS_QUERY = ZeroTermsQuery.NONE;
    protected final QueryShardContext context;
    protected String analyzer;
    protected BooleanClause.Occur occur = BooleanClause.Occur.SHOULD;
    protected boolean enablePositionIncrements = true;
    protected int phraseSlop = 0;
    protected Fuzziness fuzziness = null;
    protected int fuzzyPrefixLength = 0;
    protected int maxExpansions = 50;
    protected boolean transpositions = true;
    protected MultiTermQuery.RewriteMethod fuzzyRewriteMethod;
    protected boolean lenient = false;
    protected ZeroTermsQuery zeroTermsQuery = DEFAULT_ZERO_TERMS_QUERY;
    protected Float commonTermsCutoff = null;

    public MatchQuery(QueryShardContext context) {
        this.context = context;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public void setOccur(BooleanClause.Occur occur) {
        this.occur = occur;
    }

    public void setCommonTermsCutoff(Float cutoff) {
        this.commonTermsCutoff = cutoff;
    }

    public void setEnablePositionIncrements(boolean enablePositionIncrements) {
        this.enablePositionIncrements = enablePositionIncrements;
    }

    public void setPhraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public void setFuzziness(Fuzziness fuzziness) {
        this.fuzziness = fuzziness;
    }

    public void setFuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
    }

    public void setMaxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
    }

    public void setTranspositions(boolean transpositions) {
        this.transpositions = transpositions;
    }

    public void setFuzzyRewriteMethod(MultiTermQuery.RewriteMethod fuzzyRewriteMethod) {
        this.fuzzyRewriteMethod = fuzzyRewriteMethod;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public void setZeroTermsQuery(ZeroTermsQuery zeroTermsQuery) {
        this.zeroTermsQuery = zeroTermsQuery;
    }

    protected Analyzer getAnalyzer(MappedFieldType fieldType) {
        if (this.analyzer == null) {
            if (fieldType != null) {
                return this.context.getSearchAnalyzer(fieldType);
            }
            return this.context.getMapperService().searchAnalyzer();
        }
        NamedAnalyzer analyzer = this.context.getMapperService().getIndexAnalyzers().get(this.analyzer);
        if (analyzer == null) {
            throw new IllegalArgumentException("No analyzer found for [" + this.analyzer + "]");
        }
        return analyzer;
    }

    public Query parse(Type type, String fieldName, Object value) throws IOException {
        boolean noForcedAnalyzer;
        MappedFieldType fieldType = this.context.fieldMapper(fieldName);
        String field = fieldType != null ? fieldType.name() : fieldName;
        boolean bl = noForcedAnalyzer = this.analyzer == null;
        if (fieldType != null && !fieldType.tokenized() && noForcedAnalyzer) {
            return this.blendTermQuery(new Term(fieldName, value.toString()), fieldType);
        }
        Analyzer analyzer = this.getAnalyzer(fieldType);
        assert (analyzer != null);
        MatchQueryBuilder builder = new MatchQueryBuilder(analyzer, fieldType);
        builder.setEnablePositionIncrements(this.enablePositionIncrements);
        Query query = null;
        switch (type) {
            case BOOLEAN: {
                if (this.commonTermsCutoff == null) {
                    query = builder.createBooleanQuery(field, value.toString(), this.occur);
                    break;
                }
                query = builder.createCommonTermsQuery(field, value.toString(), this.occur, this.occur, this.commonTermsCutoff.floatValue(), fieldType);
                break;
            }
            case PHRASE: {
                query = builder.createPhraseQuery(field, value.toString(), this.phraseSlop);
                break;
            }
            case PHRASE_PREFIX: {
                query = builder.createPhrasePrefixQuery(field, value.toString(), this.phraseSlop, this.maxExpansions);
                break;
            }
            default: {
                throw new IllegalStateException("No type found for [" + type + "]");
            }
        }
        if (query == null) {
            return this.zeroTermsQuery();
        }
        return query;
    }

    protected final Query termQuery(MappedFieldType fieldType, Object value, boolean lenient) {
        try {
            return fieldType.termQuery(value, this.context);
        }
        catch (RuntimeException e) {
            if (lenient) {
                return null;
            }
            throw e;
        }
    }

    protected Query zeroTermsQuery() {
        if (this.zeroTermsQuery == DEFAULT_ZERO_TERMS_QUERY) {
            return Queries.newMatchNoDocsQuery("Matching no documents because no terms present.");
        }
        return Queries.newMatchAllQuery();
    }

    protected Query blendTermsQuery(Term[] terms, MappedFieldType fieldType) {
        return new SynonymQuery(terms);
    }

    protected Query blendTermQuery(Term term, MappedFieldType fieldType) {
        Query query;
        if (this.fuzziness != null) {
            if (fieldType != null) {
                try {
                    Query query2 = fieldType.fuzzyQuery(term.text(), this.fuzziness, this.fuzzyPrefixLength, this.maxExpansions, this.transpositions);
                    if (query2 instanceof FuzzyQuery) {
                        QueryParsers.setRewriteMethod((FuzzyQuery)query2, this.fuzzyRewriteMethod);
                    }
                    return query2;
                }
                catch (RuntimeException e) {
                    if (this.lenient) {
                        return new TermQuery(term);
                    }
                    throw e;
                }
            }
            int edits = this.fuzziness.asDistance(term.text());
            FuzzyQuery query3 = new FuzzyQuery(term, edits, this.fuzzyPrefixLength, this.maxExpansions, this.transpositions);
            QueryParsers.setRewriteMethod(query3, this.fuzzyRewriteMethod);
            return query3;
        }
        if (fieldType != null && (query = this.termQuery(fieldType, term.bytes(), this.lenient)) != null) {
            return query;
        }
        return new TermQuery(term);
    }

    private class MatchQueryBuilder
    extends QueryBuilder {
        private final MappedFieldType mapper;

        MatchQueryBuilder(@Nullable Analyzer analyzer, MappedFieldType mapper) {
            super(analyzer);
            this.mapper = mapper;
        }

        @Override
        protected Query newTermQuery(Term term) {
            return MatchQuery.this.blendTermQuery(term, this.mapper);
        }

        @Override
        protected Query newSynonymQuery(Term[] terms) {
            return MatchQuery.this.blendTermsQuery(terms, this.mapper);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Query createFieldQuery(Analyzer analyzer, BooleanClause.Occur operator, String field, String queryText, boolean quoted, int phraseSlop) {
            assert (operator == BooleanClause.Occur.SHOULD || operator == BooleanClause.Occur.MUST);
            try (TokenStream source = analyzer.tokenStream(field, queryText);){
                if (source.hasAttribute(DisableGraphAttribute.class)) {
                    this.setEnableGraphQueries(false);
                }
                Query query = super.createFieldQuery(source, operator, field, quoted, phraseSlop);
                this.setEnableGraphQueries(true);
                Query query2 = query;
                return query2;
            }
            catch (IOException e) {
                throw new RuntimeException("Error analyzing query text", e);
            }
        }

        public Query createPhrasePrefixQuery(String field, String queryText, int phraseSlop, int maxExpansions) {
            Query query = this.createFieldQuery(this.getAnalyzer(), BooleanClause.Occur.MUST, field, queryText, true, phraseSlop);
            return this.toMultiPhrasePrefix(query, phraseSlop, maxExpansions);
        }

        private Query toMultiPhrasePrefix(Query query, int phraseSlop, int maxExpansions) {
            float boost = 1.0f;
            Query innerQuery = query;
            while (innerQuery instanceof BoostQuery) {
                BoostQuery bq = (BoostQuery)innerQuery;
                boost *= bq.getBoost();
                innerQuery = bq.getQuery();
            }
            if (query instanceof SpanQuery) {
                return this.toSpanQueryPrefix((SpanQuery)query, boost);
            }
            MultiPhrasePrefixQuery prefixQuery = new MultiPhrasePrefixQuery();
            prefixQuery.setMaxExpansions(maxExpansions);
            prefixQuery.setSlop(phraseSlop);
            if (innerQuery instanceof PhraseQuery) {
                PhraseQuery pq = (PhraseQuery)innerQuery;
                Term[] terms = pq.getTerms();
                int[] positions = pq.getPositions();
                for (int i = 0; i < terms.length; ++i) {
                    prefixQuery.add(new Term[]{terms[i]}, positions[i]);
                }
                return boost == 1.0f ? prefixQuery : new BoostQuery(prefixQuery, boost);
            }
            if (innerQuery instanceof MultiPhraseQuery) {
                MultiPhraseQuery pq = (MultiPhraseQuery)innerQuery;
                Term[][] terms = pq.getTermArrays();
                int[] positions = pq.getPositions();
                for (int i = 0; i < terms.length; ++i) {
                    prefixQuery.add(terms[i], positions[i]);
                }
                return boost == 1.0f ? prefixQuery : new BoostQuery(prefixQuery, boost);
            }
            if (innerQuery instanceof TermQuery) {
                prefixQuery.add(((TermQuery)innerQuery).getTerm());
                return boost == 1.0f ? prefixQuery : new BoostQuery(prefixQuery, boost);
            }
            if (innerQuery instanceof AllTermQuery) {
                prefixQuery.add(((AllTermQuery)innerQuery).getTerm());
                return boost == 1.0f ? prefixQuery : new BoostQuery(prefixQuery, boost);
            }
            return query;
        }

        private Query toSpanQueryPrefix(SpanQuery query, float boost) {
            if (query instanceof SpanTermQuery) {
                SpanMultiTermQueryWrapper<PrefixQuery> ret = new SpanMultiTermQueryWrapper<PrefixQuery>(new PrefixQuery(((SpanTermQuery)query).getTerm()));
                return boost == 1.0f ? ret : new BoostQuery(ret, boost);
            }
            if (query instanceof SpanNearQuery) {
                SpanNearQuery spanNearQuery = (SpanNearQuery)query;
                SpanQuery[] clauses = spanNearQuery.getClauses();
                if (clauses[clauses.length - 1] instanceof SpanTermQuery) {
                    clauses[clauses.length - 1] = new SpanMultiTermQueryWrapper<PrefixQuery>(new PrefixQuery(((SpanTermQuery)clauses[clauses.length - 1]).getTerm()));
                }
                SpanNearQuery newQuery = new SpanNearQuery(clauses, spanNearQuery.getSlop(), spanNearQuery.isInOrder());
                return boost == 1.0f ? newQuery : new BoostQuery(newQuery, boost);
            }
            if (query instanceof SpanOrQuery) {
                SpanOrQuery orQuery = (SpanOrQuery)query;
                SpanQuery[] clauses = new SpanQuery[orQuery.getClauses().length];
                for (int i = 0; i < clauses.length; ++i) {
                    clauses[i] = (SpanQuery)this.toSpanQueryPrefix(orQuery.getClauses()[i], 1.0f);
                }
                return boost == 1.0f ? new SpanOrQuery(clauses) : new BoostQuery(new SpanOrQuery(clauses), boost);
            }
            return query;
        }

        public Query createCommonTermsQuery(String field, String queryText, BooleanClause.Occur highFreqOccur, BooleanClause.Occur lowFreqOccur, float maxTermFrequency, MappedFieldType fieldType) {
            Query booleanQuery = this.createBooleanQuery(field, queryText, lowFreqOccur);
            if (booleanQuery != null && booleanQuery instanceof BooleanQuery) {
                BooleanQuery bq = (BooleanQuery)booleanQuery;
                return this.boolToExtendedCommonTermsQuery(bq, highFreqOccur, lowFreqOccur, maxTermFrequency, fieldType);
            }
            return booleanQuery;
        }

        private Query boolToExtendedCommonTermsQuery(BooleanQuery bq, BooleanClause.Occur highFreqOccur, BooleanClause.Occur lowFreqOccur, float maxTermFrequency, MappedFieldType fieldType) {
            ExtendedCommonTermsQuery query = new ExtendedCommonTermsQuery(highFreqOccur, lowFreqOccur, maxTermFrequency, bq.isCoordDisabled(), fieldType);
            for (BooleanClause clause : bq.clauses()) {
                if (!(clause.getQuery() instanceof TermQuery)) {
                    return bq;
                }
                query.add(((TermQuery)clause.getQuery()).getTerm());
            }
            return query;
        }
    }

    public static enum ZeroTermsQuery implements Writeable
    {
        NONE(0),
        ALL(1);

        private final int ordinal;

        private ZeroTermsQuery(int ordinal) {
            this.ordinal = ordinal;
        }

        public static ZeroTermsQuery readFromStream(StreamInput in) throws IOException {
            int ord = in.readVInt();
            for (ZeroTermsQuery zeroTermsQuery : ZeroTermsQuery.values()) {
                if (zeroTermsQuery.ordinal != ord) continue;
                return zeroTermsQuery;
            }
            throw new ElasticsearchException("unknown serialized type [" + ord + "]", new Object[0]);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal);
        }
    }

    public static enum Type implements Writeable
    {
        BOOLEAN(0),
        PHRASE(1),
        PHRASE_PREFIX(2);

        private final int ordinal;

        private Type(int ordinal) {
            this.ordinal = ordinal;
        }

        public static Type readFromStream(StreamInput in) throws IOException {
            int ord = in.readVInt();
            for (Type type : Type.values()) {
                if (type.ordinal != ord) continue;
                return type;
            }
            throw new ElasticsearchException("unknown serialized type [" + ord + "]", new Object[0]);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal);
        }
    }
}

