/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.recovery;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.CorruptIndexException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexCommit;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexFormatTooNewException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexFormatTooOldException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.IOContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.IOUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.StopWatch;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.bytes.BytesArray;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.Streams;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lease.Releasable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.store.InputStreamIndexInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.ByteSizeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.CancellableThreads;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.engine.RecoveryEngineException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.IndexShard;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.IndexShardClosedException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.IndexShardRelocatedException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.IndexShardState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.store.Store;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.store.StoreFileMetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.translog.Translog;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.recovery.RecoverFilesRecoveryException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.recovery.RecoveryResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.recovery.RecoveryTargetHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.RemoteTransportException;

public class RecoverySourceHandler {
    protected final Logger logger;
    private final IndexShard shard;
    private final String indexName;
    private final int shardId;
    private final StartRecoveryRequest request;
    private final Supplier<Long> currentClusterStateVersionSupplier;
    private final Function<String, Releasable> delayNewRecoveries;
    private final int chunkSizeInBytes;
    private final RecoveryTargetHandler recoveryTarget;
    protected final RecoveryResponse response;
    private final CancellableThreads cancellableThreads = new CancellableThreads(){

        @Override
        protected void onCancel(String reason, @Nullable Exception suppressedException) {
            ElasticsearchException e = RecoverySourceHandler.this.shard.state() == IndexShardState.CLOSED ? new IndexShardClosedException(RecoverySourceHandler.this.shard.shardId(), "shard is closed and recovery was canceled reason [" + reason + "]") : new CancellableThreads.ExecutionCancelledException("recovery was canceled reason [" + reason + "]");
            if (suppressedException != null) {
                e.addSuppressed(suppressedException);
            }
            throw e;
        }
    };

    public RecoverySourceHandler(IndexShard shard, RecoveryTargetHandler recoveryTarget, StartRecoveryRequest request, Supplier<Long> currentClusterStateVersionSupplier, Function<String, Releasable> delayNewRecoveries, int fileChunkSizeInBytes, Logger logger) {
        this.shard = shard;
        this.recoveryTarget = recoveryTarget;
        this.request = request;
        this.currentClusterStateVersionSupplier = currentClusterStateVersionSupplier;
        this.delayNewRecoveries = delayNewRecoveries;
        this.logger = logger;
        this.indexName = this.request.shardId().getIndex().getName();
        this.shardId = this.request.shardId().id();
        this.chunkSizeInBytes = fileChunkSizeInBytes;
        this.response = new RecoveryResponse();
    }

    public RecoveryResponse recoverToTarget() throws IOException {
        try (Translog.View translogView = this.shard.acquireTranslogView();){
            IndexCommit phase1Snapshot;
            this.logger.trace("captured translog id [{}] for recovery", (Object)translogView.minTranslogGeneration());
            try {
                phase1Snapshot = this.shard.acquireIndexCommit(false);
            }
            catch (Exception e) {
                IOUtils.closeWhileHandlingException(translogView);
                throw new RecoveryEngineException(this.shard.shardId(), 1, "Snapshot failed", e);
            }
            try {
                this.phase1(phase1Snapshot, translogView);
            }
            catch (Exception e) {
                throw new RecoveryEngineException(this.shard.shardId(), 1, "phase1 failed", e);
            }
            finally {
                try {
                    this.shard.releaseIndexCommit(phase1Snapshot);
                }
                catch (IOException ex) {
                    this.logger.warn("releasing snapshot caused exception", (Throwable)ex);
                }
            }
            if (this.shard.state() == IndexShardState.RELOCATED) {
                assert (!this.request.isPrimaryRelocation()) : "recovery target should not retry primary relocation if previous attempt made it past finalization step";
                throw new IndexShardRelocatedException(this.request.shardId());
            }
            this.logger.trace("{} snapshot translog for recovery. current size is [{}]", (Object)this.shard.shardId(), (Object)translogView.totalOperations());
            try {
                this.phase2(translogView.snapshot());
            }
            catch (Exception e) {
                throw new RecoveryEngineException(this.shard.shardId(), 2, "phase2 failed", e);
            }
            this.finalizeRecovery();
        }
        return this.response;
    }

    public void phase1(IndexCommit snapshot, Translog.View translogView) {
        this.cancellableThreads.checkForCancel();
        long totalSize = 0L;
        long existingTotalSize = 0L;
        Store store = this.shard.store();
        store.incRef();
        try {
            boolean recoverWithSyncId;
            Store.MetadataSnapshot recoverySourceMetadata;
            StopWatch stopWatch = new StopWatch().start();
            try {
                recoverySourceMetadata = store.getMetadata(snapshot);
            }
            catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                this.shard.failShard("recovery", ex);
                throw ex;
            }
            for (String name : snapshot.getFileNames()) {
                StoreFileMetaData md2 = recoverySourceMetadata.get(name);
                if (md2 != null) continue;
                this.logger.info("Snapshot differs from actual index for file: {} meta: {}", (Object)name, (Object)recoverySourceMetadata.asMap());
                throw new CorruptIndexException("Snapshot differs from actual index - maybe index was removed metadata has " + recoverySourceMetadata.asMap().size() + " files", name);
            }
            String recoverySourceSyncId = recoverySourceMetadata.getSyncId();
            String recoveryTargetSyncId = this.request.metadataSnapshot().getSyncId();
            boolean bl = recoverWithSyncId = recoverySourceSyncId != null && recoverySourceSyncId.equals(recoveryTargetSyncId);
            if (recoverWithSyncId) {
                long l;
                long numDocsTarget = this.request.metadataSnapshot().getNumDocs();
                if (numDocsTarget != (l = recoverySourceMetadata.getNumDocs())) {
                    throw new IllegalStateException("try to recover " + this.request.shardId() + " from primary shard with sync id but number of docs differ: " + l + " (" + this.request.sourceNode().getName() + ", primary) vs " + numDocsTarget + "(" + this.request.targetNode().getName() + ")");
                }
                this.logger.trace("[{}][{}] skipping [phase1] to {} - identical sync id [{}] found on both source and target", (Object)this.indexName, (Object)this.shardId, (Object)this.request.targetNode(), (Object)recoverySourceSyncId);
            } else {
                Store.RecoveryDiff diff = recoverySourceMetadata.recoveryDiff(this.request.metadataSnapshot());
                for (StoreFileMetaData storeFileMetaData : diff.identical) {
                    this.response.phase1ExistingFileNames.add(storeFileMetaData.name());
                    this.response.phase1ExistingFileSizes.add(storeFileMetaData.length());
                    existingTotalSize += storeFileMetaData.length();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("[{}][{}] recovery [phase1] to {}: not recovering [{}], exists in local store and has checksum [{}], size [{}]", (Object)this.indexName, (Object)this.shardId, (Object)this.request.targetNode(), (Object)storeFileMetaData.name(), (Object)storeFileMetaData.checksum(), (Object)storeFileMetaData.length());
                    }
                    totalSize += storeFileMetaData.length();
                }
                ArrayList<StoreFileMetaData> phase1Files = new ArrayList<StoreFileMetaData>(diff.different.size() + diff.missing.size());
                phase1Files.addAll(diff.different);
                phase1Files.addAll(diff.missing);
                for (StoreFileMetaData md4 : phase1Files) {
                    if (this.request.metadataSnapshot().asMap().containsKey(md4.name())) {
                        this.logger.trace("[{}][{}] recovery [phase1] to {}: recovering [{}], exists in local store, but is different: remote [{}], local [{}]", (Object)this.indexName, (Object)this.shardId, (Object)this.request.targetNode(), (Object)md4.name(), (Object)this.request.metadataSnapshot().asMap().get(md4.name()), (Object)md4);
                    } else {
                        this.logger.trace("[{}][{}] recovery [phase1] to {}: recovering [{}], does not exists in remote", (Object)this.indexName, (Object)this.shardId, (Object)this.request.targetNode(), (Object)md4.name());
                    }
                    this.response.phase1FileNames.add(md4.name());
                    this.response.phase1FileSizes.add(md4.length());
                    totalSize += md4.length();
                }
                this.response.phase1TotalSize = totalSize;
                this.response.phase1ExistingTotalSize = existingTotalSize;
                this.logger.trace("[{}][{}] recovery [phase1] to {}: recovering_files [{}] with total_size [{}], reusing_files [{}] with total_size [{}]", (Object)this.indexName, (Object)this.shardId, (Object)this.request.targetNode(), (Object)this.response.phase1FileNames.size(), (Object)new ByteSizeValue(totalSize), (Object)this.response.phase1ExistingFileNames.size(), (Object)new ByteSizeValue(existingTotalSize));
                this.cancellableThreads.execute(() -> this.recoveryTarget.receiveFileInfo(this.response.phase1FileNames, this.response.phase1FileSizes, this.response.phase1ExistingFileNames, this.response.phase1ExistingFileSizes, translogView.totalOperations()));
                Function<StoreFileMetaData, OutputStream> function = md -> new BufferedOutputStream(new RecoveryOutputStream((StoreFileMetaData)md, translogView), this.chunkSizeInBytes);
                this.sendFiles(store, phase1Files.toArray(new StoreFileMetaData[phase1Files.size()]), function);
                try {
                    this.cancellableThreads.executeIO(() -> this.recoveryTarget.cleanFiles(translogView.totalOperations(), recoverySourceMetadata));
                }
                catch (IOException | RemoteTransportException targetException) {
                    IOException corruptIndexException = ExceptionsHelper.unwrapCorruption(targetException);
                    if (corruptIndexException != null) {
                        try {
                            Store.MetadataSnapshot recoverySourceMetadata1 = store.getMetadata(snapshot);
                            StoreFileMetaData[] metadata = (StoreFileMetaData[])StreamSupport.stream(recoverySourceMetadata1.spliterator(), false).toArray(StoreFileMetaData[]::new);
                            ArrayUtil.timSort(metadata, (o1, o2) -> Long.compare(o1.length(), o2.length()));
                            for (StoreFileMetaData md5 : metadata) {
                                this.cancellableThreads.checkForCancel();
                                this.logger.debug("{} checking integrity for file {} after remove corruption exception", (Object)this.shard.shardId(), (Object)md5);
                                if (store.checkIntegrityNoException(md5)) continue;
                                this.shard.failShard("recovery", corruptIndexException);
                                this.logger.warn("{} Corrupted file detected {} checksum mismatch", (Object)this.shard.shardId(), (Object)md5);
                                throw corruptIndexException;
                            }
                        }
                        catch (IOException ex) {
                            targetException.addSuppressed(ex);
                            throw targetException;
                        }
                        RemoteTransportException exception = new RemoteTransportException("File corruption occurred on recovery but checksums are ok", null);
                        exception.addSuppressed(targetException);
                        this.logger.warn(() -> new ParameterizedMessage("{} Remote file corruption during finalization of recovery on node {}. local checksum OK", (Object)this.shard.shardId(), (Object)this.request.targetNode()), (Throwable)corruptIndexException);
                        throw exception;
                    }
                    throw targetException;
                }
            }
            this.prepareTargetForTranslog(translogView.totalOperations(), this.shard.segmentStats(false).getMaxUnsafeAutoIdTimestamp());
            this.logger.trace("[{}][{}] recovery [phase1] to {}: took [{}]", (Object)this.indexName, (Object)this.shardId, (Object)this.request.targetNode(), (Object)stopWatch.totalTime());
            this.response.phase1Time = stopWatch.totalTime().millis();
        }
        catch (Exception e) {
            throw new RecoverFilesRecoveryException(this.request.shardId(), this.response.phase1FileNames.size(), new ByteSizeValue(totalSize), e);
        }
        finally {
            store.decRef();
        }
    }

    protected void prepareTargetForTranslog(int totalTranslogOps, long maxUnsafeAutoIdTimestamp) throws IOException {
        StopWatch stopWatch = new StopWatch().start();
        this.logger.trace("{} recovery [phase1] to {}: prepare remote engine for translog", (Object)this.request.shardId(), (Object)this.request.targetNode());
        long startEngineStart = stopWatch.totalTime().millis();
        this.cancellableThreads.executeIO(() -> this.recoveryTarget.prepareForTranslogOperations(totalTranslogOps, maxUnsafeAutoIdTimestamp));
        stopWatch.stop();
        this.response.startTime = stopWatch.totalTime().millis() - startEngineStart;
        this.logger.trace("{} recovery [phase1] to {}: remote engine start took [{}]", (Object)this.request.shardId(), (Object)this.request.targetNode(), (Object)stopWatch.totalTime());
    }

    public void phase2(Translog.Snapshot snapshot) {
        if (this.shard.state() == IndexShardState.CLOSED) {
            throw new IndexShardClosedException(this.request.shardId());
        }
        this.cancellableThreads.checkForCancel();
        StopWatch stopWatch = new StopWatch().start();
        this.logger.trace("{} recovery [phase2] to {}: sending transaction log operations", (Object)this.request.shardId(), (Object)this.request.targetNode());
        int totalOperations = this.sendSnapshot(snapshot);
        stopWatch.stop();
        this.logger.trace("{} recovery [phase2] to {}: took [{}]", (Object)this.request.shardId(), (Object)this.request.targetNode(), (Object)stopWatch.totalTime());
        this.response.phase2Time = stopWatch.totalTime().millis();
        this.response.phase2Operations = totalOperations;
    }

    public void finalizeRecovery() {
        if (this.shard.state() == IndexShardState.CLOSED) {
            throw new IndexShardClosedException(this.request.shardId());
        }
        this.cancellableThreads.checkForCancel();
        StopWatch stopWatch = new StopWatch().start();
        this.logger.trace("[{}][{}] finalizing recovery to {}", (Object)this.indexName, (Object)this.shardId, (Object)this.request.targetNode());
        this.cancellableThreads.execute(this.recoveryTarget::finalizeRecovery);
        if (this.request.isPrimaryRelocation()) {
            try (Releasable ignored = this.delayNewRecoveries.apply("primary relocation hand-off in progress or completed for " + this.shardId);){
                long currentClusterStateVersion = this.currentClusterStateVersionSupplier.get();
                this.logger.trace("[{}][{}] waiting on {} to have cluster state with version [{}]", (Object)this.indexName, (Object)this.shardId, (Object)this.request.targetNode(), (Object)currentClusterStateVersion);
                this.cancellableThreads.execute(() -> this.recoveryTarget.ensureClusterStateVersion(currentClusterStateVersion));
                this.logger.trace("[{}][{}] performing relocation hand-off to {}", (Object)this.indexName, (Object)this.shardId, (Object)this.request.targetNode());
                this.cancellableThreads.execute(() -> this.shard.relocated("to " + this.request.targetNode()));
            }
        }
        stopWatch.stop();
        this.logger.trace("[{}][{}] finalizing recovery to {}: took [{}]", (Object)this.indexName, (Object)this.shardId, (Object)this.request.targetNode(), (Object)stopWatch.totalTime());
    }

    protected int sendSnapshot(Translog.Snapshot snapshot) {
        Translog.Operation operation;
        int ops = 0;
        long size = 0L;
        int totalOperations = 0;
        ArrayList<Translog.Operation> operations = new ArrayList<Translog.Operation>();
        try {
            operation = snapshot.next();
        }
        catch (IOException ex) {
            throw new ElasticsearchException("failed to get next operation from translog", (Throwable)ex, new Object[0]);
        }
        if (operation == null) {
            this.logger.trace("[{}][{}] no translog operations to send to {}", (Object)this.indexName, (Object)this.shardId, (Object)this.request.targetNode());
        }
        while (operation != null) {
            if (this.shard.state() == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.request.shardId());
            }
            this.cancellableThreads.checkForCancel();
            operations.add(operation);
            ++ops;
            ++totalOperations;
            if ((size += operation.estimateSize()) >= (long)this.chunkSizeInBytes) {
                this.cancellableThreads.execute(() -> this.recoveryTarget.indexTranslogOperations(operations, snapshot.totalOperations()));
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[{}][{}] sent batch of [{}][{}] (total: [{}]) translog operations to {}", (Object)this.indexName, (Object)this.shardId, (Object)ops, (Object)new ByteSizeValue(size), (Object)snapshot.totalOperations(), (Object)this.request.targetNode());
                }
                ops = 0;
                size = 0L;
                operations.clear();
            }
            try {
                operation = snapshot.next();
            }
            catch (IOException ex) {
                throw new ElasticsearchException("failed to get next operation from translog", (Throwable)ex, new Object[0]);
            }
        }
        if (!operations.isEmpty()) {
            this.cancellableThreads.execute(() -> this.recoveryTarget.indexTranslogOperations(operations, snapshot.totalOperations()));
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}][{}] sent final batch of [{}][{}] (total: [{}]) translog operations to {}", (Object)this.indexName, (Object)this.shardId, (Object)ops, (Object)new ByteSizeValue(size), (Object)snapshot.totalOperations(), (Object)this.request.targetNode());
        }
        return totalOperations;
    }

    public void cancel(String reason) {
        this.cancellableThreads.cancel(reason);
    }

    public String toString() {
        return "ShardRecoveryHandler{shardId=" + this.request.shardId() + ", sourceNode=" + this.request.sourceNode() + ", targetNode=" + this.request.targetNode() + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendFiles(Store store, StoreFileMetaData[] files, Function<StoreFileMetaData, OutputStream> outputStreamFactory) throws Exception {
        store.incRef();
        try {
            ArrayUtil.timSort(files, (a, b) -> Long.compare(a.length(), b.length()));
            for (int i = 0; i < files.length; ++i) {
                StoreFileMetaData md = files[i];
                try (IndexInput indexInput = store.directory().openInput(md.name(), IOContext.READONCE);){
                    Streams.copy(new InputStreamIndexInput(indexInput, md.length()), outputStreamFactory.apply(md));
                    continue;
                }
                catch (Exception e) {
                    IOException corruptIndexException = ExceptionsHelper.unwrapCorruption(e);
                    if (corruptIndexException != null) {
                        if (!store.checkIntegrityNoException(md)) {
                            this.logger.warn("{} Corrupted file detected {} checksum mismatch", (Object)this.shardId, (Object)md);
                            this.failEngine(corruptIndexException);
                            throw corruptIndexException;
                        }
                        RemoteTransportException exception = new RemoteTransportException("File corruption occurred on recovery but checksums are ok", null);
                        exception.addSuppressed(e);
                        this.logger.warn(() -> new ParameterizedMessage("{} Remote file corruption on node {}, recovering {}. local checksum OK", this.shardId, this.request.targetNode(), md), (Throwable)corruptIndexException);
                        throw exception;
                    }
                    throw e;
                }
            }
        }
        finally {
            store.decRef();
        }
    }

    protected void failEngine(IOException cause) {
        this.shard.failShard("recovery", cause);
    }

    final class RecoveryOutputStream
    extends OutputStream {
        private final StoreFileMetaData md;
        private final Translog.View translogView;
        private long position = 0L;

        RecoveryOutputStream(StoreFileMetaData md, Translog.View translogView) {
            this.md = md;
            this.translogView = translogView;
        }

        @Override
        public void write(int b) throws IOException {
            throw new UnsupportedOperationException("we can't send single bytes over the wire");
        }

        @Override
        public void write(byte[] b, int offset, int length) throws IOException {
            this.sendNextChunk(this.position, new BytesArray(b, offset, length), this.md.length() == this.position + (long)length);
            this.position += (long)length;
            assert (this.md.length() >= this.position) : "length: " + this.md.length() + " but positions was: " + this.position;
        }

        private void sendNextChunk(long position, BytesArray content, boolean lastChunk) throws IOException {
            RecoverySourceHandler.this.cancellableThreads.executeIO(() -> RecoverySourceHandler.this.recoveryTarget.writeFileChunk(this.md, position, content, lastChunk, this.translogView.totalOperations()));
            if (RecoverySourceHandler.this.shard.state() == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(RecoverySourceHandler.this.request.shardId());
            }
        }
    }
}

