/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.node;

import java.io.Closeable;
import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Build;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.AbstractComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.SettingsFilter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.Discovery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.http.HttpServerTransport;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.IndicesService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.IngestService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.monitor.MonitorService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.plugins.PluginsService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.ScriptService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportService;

public class NodeService
extends AbstractComponent
implements Closeable {
    private final ThreadPool threadPool;
    private final MonitorService monitorService;
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final PluginsService pluginService;
    private final CircuitBreakerService circuitBreakerService;
    private final IngestService ingestService;
    private final SettingsFilter settingsFilter;
    private ScriptService scriptService;
    private final HttpServerTransport httpServerTransport;
    private final Discovery discovery;

    NodeService(Settings settings, ThreadPool threadPool, MonitorService monitorService, Discovery discovery, TransportService transportService, IndicesService indicesService, PluginsService pluginService, CircuitBreakerService circuitBreakerService, ScriptService scriptService, @Nullable HttpServerTransport httpServerTransport, IngestService ingestService, ClusterService clusterService, SettingsFilter settingsFilter) {
        super(settings);
        this.threadPool = threadPool;
        this.monitorService = monitorService;
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.discovery = discovery;
        this.pluginService = pluginService;
        this.circuitBreakerService = circuitBreakerService;
        this.httpServerTransport = httpServerTransport;
        this.ingestService = ingestService;
        this.settingsFilter = settingsFilter;
        this.scriptService = scriptService;
        clusterService.addStateApplier(ingestService.getPipelineStore());
        clusterService.addStateApplier(ingestService.getPipelineExecutionService());
    }

    public NodeInfo info(boolean settings, boolean os, boolean process, boolean jvm, boolean threadPool, boolean transport, boolean http, boolean plugin, boolean ingest, boolean indices) {
        return new NodeInfo(Version.CURRENT, Build.CURRENT, this.discovery.localNode(), settings ? this.settingsFilter.filter(this.settings) : null, os ? this.monitorService.osService().info() : null, process ? this.monitorService.processService().info() : null, jvm ? this.monitorService.jvmService().info() : null, threadPool ? this.threadPool.info() : null, transport ? this.transportService.info() : null, http ? (this.httpServerTransport == null ? null : this.httpServerTransport.info()) : null, plugin ? (this.pluginService == null ? null : this.pluginService.info()) : null, ingest ? (this.ingestService == null ? null : this.ingestService.info()) : null, indices ? this.indicesService.getTotalIndexingBufferBytes() : null);
    }

    public NodeStats stats(CommonStatsFlags indices, boolean os, boolean process, boolean jvm, boolean threadPool, boolean fs, boolean transport, boolean http, boolean circuitBreaker, boolean script, boolean discoveryStats, boolean ingest) {
        return new NodeStats(this.discovery.localNode(), System.currentTimeMillis(), indices.anySet() ? this.indicesService.stats(true, indices) : null, os ? this.monitorService.osService().stats() : null, process ? this.monitorService.processService().stats() : null, jvm ? this.monitorService.jvmService().stats() : null, threadPool ? this.threadPool.stats() : null, fs ? this.monitorService.fsService().stats() : null, transport ? this.transportService.stats() : null, http ? (this.httpServerTransport == null ? null : this.httpServerTransport.stats()) : null, circuitBreaker ? this.circuitBreakerService.stats() : null, script ? this.scriptService.stats() : null, discoveryStats ? this.discovery.stats() : null, ingest ? this.ingestService.getPipelineExecutionService().stats() : null);
    }

    public IngestService getIngestService() {
        return this.ingestService;
    }

    @Override
    public void close() throws IOException {
        this.indicesService.close();
    }
}

