/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.geogrid.GeoGridAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoHashGrid;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.SearchContext;

public class GeoHashGridAggregatorFactory
extends ValuesSourceAggregatorFactory<ValuesSource.GeoPoint, GeoHashGridAggregatorFactory> {
    private final int precision;
    private final int requiredSize;
    private final int shardSize;

    public GeoHashGridAggregatorFactory(String name, ValuesSourceConfig<ValuesSource.GeoPoint> config, int precision, int requiredSize, int shardSize, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metaData);
        this.precision = precision;
        this.requiredSize = requiredSize;
        this.shardSize = shardSize;
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        final InternalGeoHashGrid aggregation = new InternalGeoHashGrid(this.name, this.requiredSize, Collections.emptyList(), pipelineAggregators, metaData);
        return new NonCollectingAggregator(this.name, this.context, parent, pipelineAggregators, metaData){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource.GeoPoint valuesSource, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        if (!collectsFromSingleBucket) {
            return GeoHashGridAggregatorFactory.asMultiBucketAggregator(this, this.context, parent);
        }
        GeoGridAggregationBuilder.CellIdSource cellIdSource = new GeoGridAggregationBuilder.CellIdSource(valuesSource, this.precision);
        return new GeoHashGridAggregator(this.name, this.factories, cellIdSource, this.requiredSize, this.shardSize, this.context, parent, pipelineAggregators, metaData);
    }
}

