/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Fields;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.ReaderUtil;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.DeprecationLogger;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.Loggers;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.MinimalMap;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.lookup.IndexField;

public class LeafIndexLookup
extends MinimalMap<String, IndexField> {
    private final LeafReader reader;
    private final IndexReader parentReader;
    private final IndexSearcher indexSearcher;
    private int docId = -1;
    private final Map<String, IndexField> indexFields = new HashMap<String, IndexField>();
    private int numDocs = -1;
    private int maxDoc = -1;
    private int numDeletedDocs = -1;
    private boolean deprecationEmitted = false;

    private void logDeprecation() {
        if (!this.deprecationEmitted) {
            Logger logger = Loggers.getLogger(this.getClass());
            DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
            deprecationLogger.deprecated("Using _index is deprecated. Create a custom ScriptEngine to access index internals.", new Object[0]);
            this.deprecationEmitted = true;
        }
    }

    public int numDocs() {
        this.logDeprecation();
        if (this.numDocs == -1) {
            this.numDocs = this.parentReader.numDocs();
        }
        return this.numDocs;
    }

    public int maxDoc() {
        this.logDeprecation();
        if (this.maxDoc == -1) {
            this.maxDoc = this.parentReader.maxDoc();
        }
        return this.maxDoc;
    }

    public int numDeletedDocs() {
        this.logDeprecation();
        if (this.numDeletedDocs == -1) {
            this.numDeletedDocs = this.parentReader.numDeletedDocs();
        }
        return this.numDeletedDocs;
    }

    public LeafIndexLookup(LeafReaderContext ctx) {
        this.reader = ctx.reader();
        this.parentReader = ReaderUtil.getTopLevelContext(ctx).reader();
        this.indexSearcher = new IndexSearcher(this.parentReader);
        this.indexSearcher.setQueryCache(null);
    }

    public void setDocument(int docId) {
        if (this.docId == docId) {
            return;
        }
        if (this.docId > docId) {
            this.indexFields.clear();
        }
        this.docId = docId;
        this.setNextDocIdInFields();
    }

    protected void setNextDocIdInFields() {
        for (IndexField stat : this.indexFields.values()) {
            stat.setDocIdInTerms(this.docId);
        }
    }

    @Override
    public IndexField get(Object key) {
        this.logDeprecation();
        String stringField = (String)key;
        IndexField indexField = this.indexFields.get(key);
        if (indexField == null) {
            try {
                indexField = new IndexField(stringField, this);
                this.indexFields.put(stringField, indexField);
            }
            catch (IOException e) {
                throw new ElasticsearchException(e);
            }
        }
        return indexField;
    }

    public Fields termVectors() throws IOException {
        this.logDeprecation();
        assert (this.reader != null);
        return this.reader.getTermVectors(this.docId);
    }

    LeafReader getReader() {
        this.logDeprecation();
        return this.reader;
    }

    public int getDocId() {
        this.logDeprecation();
        return this.docId;
    }

    public IndexReader getParentReader() {
        this.logDeprecation();
        if (this.parentReader == null) {
            return this.reader;
        }
        return this.parentReader;
    }

    public IndexSearcher getIndexSearcher() {
        this.logDeprecation();
        return this.indexSearcher;
    }

    public IndexReaderContext getReaderContext() {
        this.logDeprecation();
        return this.getParentReader().getContext();
    }
}

