/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.tribe;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch5.org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterChangedEvent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterStateListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.block.ClusterBlock;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.block.ClusterBlocks;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.MetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.node.DiscoveryNodes;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.RoutingTable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Priority;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.UUIDs;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.hash.MurmurHash3;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.DeprecationLogger;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.Loggers;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.network.NetworkModule;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.network.NetworkService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.regex.Regex;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Setting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.set.Sets;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.DiscoveryModule;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.discovery.DiscoverySettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.NodeEnvironment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.gateway.GatewayService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.node.Node;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestStatus;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportSettings;

public class TribeService
extends AbstractLifecycleComponent {
    public static final ClusterBlock TRIBE_METADATA_BLOCK = new ClusterBlock(10, "tribe node, metadata not allowed", false, false, false, RestStatus.BAD_REQUEST, EnumSet.of(ClusterBlockLevel.METADATA_READ, ClusterBlockLevel.METADATA_WRITE));
    public static final ClusterBlock TRIBE_WRITE_BLOCK = new ClusterBlock(11, "tribe node, write not allowed", false, false, false, RestStatus.BAD_REQUEST, EnumSet.of(ClusterBlockLevel.WRITE));
    public static final Setting<String> TRIBE_NAME_SETTING = Setting.simpleString("tribe.name", Setting.Property.NodeScope);
    private final ClusterService clusterService;
    private final String[] blockIndicesWrite;
    private final String[] blockIndicesRead;
    private final String[] blockIndicesMetadata;
    private static final String ON_CONFLICT_ANY = "any";
    private static final String ON_CONFLICT_DROP = "drop";
    private static final String ON_CONFLICT_PREFER = "prefer_";
    public static final Setting<String> ON_CONFLICT_SETTING = new Setting<String>("tribe.on_conflict", "any", s -> {
        switch (s) {
            case "any": 
            case "drop": {
                return s;
            }
        }
        if (s.startsWith(ON_CONFLICT_PREFER) && s.length() > ON_CONFLICT_PREFER.length()) {
            return s;
        }
        throw new IllegalArgumentException("Invalid value for [tribe.on_conflict] must be either [any, drop or start with prefer_] but was: [" + s + "]");
    }, Setting.Property.NodeScope);
    public static final Setting<Boolean> BLOCKS_METADATA_SETTING = Setting.boolSetting("tribe.blocks.metadata", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> BLOCKS_WRITE_SETTING = Setting.boolSetting("tribe.blocks.write", false, Setting.Property.NodeScope);
    public static final Setting<List<String>> BLOCKS_WRITE_INDICES_SETTING = Setting.listSetting("tribe.blocks.write.indices", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    public static final Setting<List<String>> BLOCKS_READ_INDICES_SETTING = Setting.listSetting("tribe.blocks.read.indices", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    public static final Setting<List<String>> BLOCKS_METADATA_INDICES_SETTING = Setting.listSetting("tribe.blocks.metadata.indices", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    public static final Set<String> TRIBE_SETTING_KEYS = Sets.newHashSet(TRIBE_NAME_SETTING.getKey(), ON_CONFLICT_SETTING.getKey(), BLOCKS_METADATA_INDICES_SETTING.getKey(), BLOCKS_METADATA_SETTING.getKey(), BLOCKS_READ_INDICES_SETTING.getKey(), BLOCKS_WRITE_INDICES_SETTING.getKey(), BLOCKS_WRITE_SETTING.getKey());
    private static final List<Setting<?>> PASS_THROUGH_SETTINGS = Arrays.asList(NetworkService.GLOBAL_NETWORK_HOST_SETTING, NetworkService.GLOBAL_NETWORK_BINDHOST_SETTING, NetworkService.GLOBAL_NETWORK_PUBLISHHOST_SETTING, TransportSettings.HOST, TransportSettings.BIND_HOST, TransportSettings.PUBLISH_HOST);
    private final String onConflict;
    private final Set<String> droppedIndices = ConcurrentCollections.newConcurrentSet();
    private final List<Node> nodes = new CopyOnWriteArrayList<Node>();
    private final NamedWriteableRegistry namedWriteableRegistry;

    public static Settings processSettings(Settings settings) {
        if (TRIBE_NAME_SETTING.exists(settings)) {
            Settings.Builder sb = Settings.builder().put(settings);
            for (String s : settings.getAsMap().keySet()) {
                if (!s.startsWith("tribe.") || s.equals(TRIBE_NAME_SETTING.getKey())) continue;
                sb.remove(s);
            }
            return sb.build();
        }
        Map<String, Settings> nodesSettings = settings.getGroups("tribe", true);
        if (nodesSettings.isEmpty()) {
            return settings;
        }
        Settings.Builder sb = Settings.builder().put(settings);
        sb.put(Node.NODE_MASTER_SETTING.getKey(), false);
        sb.put(Node.NODE_DATA_SETTING.getKey(), false);
        sb.put(Node.NODE_INGEST_SETTING.getKey(), false);
        if (!NodeEnvironment.MAX_LOCAL_STORAGE_NODES_SETTING.exists(settings)) {
            sb.put(NodeEnvironment.MAX_LOCAL_STORAGE_NODES_SETTING.getKey(), nodesSettings.size());
        }
        sb.put(DiscoveryModule.DISCOVERY_TYPE_SETTING.getKey(), "none");
        sb.put(DiscoverySettings.INITIAL_STATE_TIMEOUT_SETTING.getKey(), 0);
        if (sb.get("cluster.name") == null) {
            sb.put("cluster.name", "tribe_" + UUIDs.randomBase64UUID());
        }
        sb.put(TransportMasterNodeReadAction.FORCE_LOCAL_SETTING.getKey(), true);
        return sb.build();
    }

    public TribeService(Settings settings, ClusterService clusterService, String tribeNodeId, NamedWriteableRegistry namedWriteableRegistry, Function<Settings, Node> clientNodeBuilder) {
        super(settings);
        this.clusterService = clusterService;
        this.namedWriteableRegistry = namedWriteableRegistry;
        HashMap<String, Settings> nodesSettings = new HashMap<String, Settings>(settings.getGroups("tribe", true));
        nodesSettings.remove("blocks");
        nodesSettings.remove("on_conflict");
        for (Map.Entry entry : nodesSettings.entrySet()) {
            Settings clientSettings = TribeService.buildClientSettings((String)entry.getKey(), tribeNodeId, settings, (Settings)entry.getValue());
            this.nodes.add(clientNodeBuilder.apply(clientSettings));
        }
        this.blockIndicesMetadata = BLOCKS_METADATA_INDICES_SETTING.get(settings).toArray(Strings.EMPTY_ARRAY);
        this.blockIndicesRead = BLOCKS_READ_INDICES_SETTING.get(settings).toArray(Strings.EMPTY_ARRAY);
        this.blockIndicesWrite = BLOCKS_WRITE_INDICES_SETTING.get(settings).toArray(Strings.EMPTY_ARRAY);
        if (!this.nodes.isEmpty()) {
            if (BLOCKS_WRITE_SETTING.get(settings).booleanValue()) {
                clusterService.addInitialStateBlock(TRIBE_WRITE_BLOCK);
            }
            if (BLOCKS_METADATA_SETTING.get(settings).booleanValue()) {
                clusterService.addInitialStateBlock(TRIBE_METADATA_BLOCK);
            }
            new DeprecationLogger(Loggers.getLogger(TribeService.class)).deprecated("tribe nodes are deprecated in favor of cross-cluster search and will be removed in Elasticsearch 7.0.0", new Object[0]);
        }
        this.onConflict = ON_CONFLICT_SETTING.get(settings);
    }

    static Settings buildClientSettings(String tribeName, String parentNodeId, Settings globalSettings, Settings tribeSettings) {
        for (String string : tribeSettings.getAsMap().keySet()) {
            if (!string.startsWith("path.")) continue;
            throw new IllegalArgumentException("Setting [" + string + "] not allowed in tribe client [" + tribeName + "]");
        }
        Settings.Builder sb = Settings.builder().put(tribeSettings);
        sb.put(Node.NODE_NAME_SETTING.getKey(), Node.NODE_NAME_SETTING.get(globalSettings) + "/" + tribeName);
        sb.put(Environment.PATH_HOME_SETTING.getKey(), Environment.PATH_HOME_SETTING.get(globalSettings));
        if (Environment.PATH_CONF_SETTING.exists(globalSettings)) {
            sb.put(Environment.PATH_CONF_SETTING.getKey(), Environment.PATH_CONF_SETTING.get(globalSettings));
        }
        if (Environment.PATH_LOGS_SETTING.exists(globalSettings)) {
            sb.put(Environment.PATH_LOGS_SETTING.getKey(), Environment.PATH_LOGS_SETTING.get(globalSettings));
        }
        if (Environment.PATH_SCRIPTS_SETTING.exists(globalSettings)) {
            sb.put(Environment.PATH_SCRIPTS_SETTING.getKey(), Environment.PATH_SCRIPTS_SETTING.get(globalSettings));
        }
        for (Setting<?> setting : PASS_THROUGH_SETTINGS) {
            if (setting.exists(tribeSettings) || !setting.exists(globalSettings)) continue;
            sb.put(setting.getKey(), globalSettings.get(setting.getKey()));
        }
        sb.put(TRIBE_NAME_SETTING.getKey(), tribeName);
        if (sb.get(NetworkModule.HTTP_ENABLED.getKey()) == null) {
            sb.put(NetworkModule.HTTP_ENABLED.getKey(), false);
        }
        sb.put(Node.NODE_DATA_SETTING.getKey(), false);
        sb.put(Node.NODE_MASTER_SETTING.getKey(), false);
        sb.put(Node.NODE_INGEST_SETTING.getKey(), false);
        BytesRef bytesRef = new BytesRef(parentNodeId + "/" + tribeName);
        long l = MurmurHash3.hash128((byte[])bytesRef.bytes, (int)bytesRef.offset, (int)bytesRef.length, (long)0L, (MurmurHash3.Hash128)new MurmurHash3.Hash128()).h1;
        sb.put(NodeEnvironment.NODE_ID_SEED_SETTING.getKey(), l);
        sb.put(Node.NODE_LOCAL_STORAGE_SETTING.getKey(), false);
        return sb.build();
    }

    @Override
    protected void doStart() {
        if (!this.nodes.isEmpty()) {
            this.clusterService.removeInitialStateBlock(2);
            this.clusterService.removeInitialStateBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK);
        }
    }

    public void startNodes() {
        for (Node node : this.nodes) {
            try {
                TribeService.getClusterService(node).addListener(new TribeClusterStateListener(node));
                node.start();
            }
            catch (Exception e) {
                for (Node otherNode : this.nodes) {
                    try {
                        otherNode.close();
                    }
                    catch (Exception inner) {
                        inner.addSuppressed(e);
                        this.logger.warn(() -> new ParameterizedMessage("failed to close node {} on failed start", (Object)otherNode), (Throwable)inner);
                    }
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ElasticsearchException(e);
            }
        }
    }

    @Override
    protected void doStop() {
        this.doClose();
    }

    @Override
    protected void doClose() {
        for (Node node : this.nodes) {
            try {
                node.close();
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("failed to close node {}", (Object)node), (Throwable)e);
            }
        }
    }

    private static ClusterService getClusterService(Node node) {
        return node.injector().getInstance(ClusterService.class);
    }

    static Map<String, MetaData.Custom> mergeChangedCustomMetaData(Set<String> changedCustomMetaDataTypeSet, Function<String, List<MergableCustomMetaData>> customMetaDataByTribeNode) {
        HashMap<String, MetaData.Custom> changedCustomMetaDataMap = new HashMap<String, MetaData.Custom>(changedCustomMetaDataTypeSet.size());
        for (String customMetaDataType : changedCustomMetaDataTypeSet) {
            customMetaDataByTribeNode.apply(customMetaDataType).stream().reduce((mergableCustomMD, mergableCustomMD2) -> (MergableCustomMetaData)((Object)mergableCustomMD.merge((MetaData.Custom)((Object)mergableCustomMD2)))).ifPresent(mergedCustomMetaData -> changedCustomMetaDataMap.put(customMetaDataType, (MetaData.Custom)((Object)mergedCustomMetaData)));
        }
        return changedCustomMetaDataMap;
    }

    /*
     * Exception decompiling
     */
    private MetaData.Custom marshal(MetaData.Custom custom) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    class TribeNodeClusterStateTaskExecutor
    implements ClusterStateTaskExecutor<ClusterChangedEvent> {
        private final String tribeName;

        TribeNodeClusterStateTaskExecutor(String tribeName) {
            this.tribeName = tribeName;
        }

        @Override
        public String describeTasks(List<ClusterChangedEvent> tasks) {
            return tasks.stream().map(ClusterChangedEvent::source).reduce((s1, s2) -> s1 + ", " + s2).orElse("");
        }

        @Override
        public boolean runOnlyOnMaster() {
            return false;
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<ClusterChangedEvent> execute(ClusterState currentState, List<ClusterChangedEvent> tasks) throws Exception {
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<ClusterChangedEvent> builder = ClusterStateTaskExecutor.ClusterTasksResult.builder();
            ClusterState.Builder newState = ClusterState.builder(currentState).incrementVersion();
            boolean clusterStateChanged = this.updateNodes(currentState, tasks, newState);
            builder.successes(tasks);
            return builder.build((clusterStateChanged |= this.updateIndicesAndMetaData(currentState, tasks, newState)) ? newState.build() : currentState);
        }

        private boolean updateNodes(ClusterState currentState, List<ClusterChangedEvent> tasks, ClusterState.Builder newState) {
            boolean clusterStateChanged = false;
            ClusterChangedEvent latestTask = tasks.get(tasks.size() - 1);
            ClusterState tribeState = latestTask.state();
            DiscoveryNodes.Builder nodes = DiscoveryNodes.builder(currentState.nodes());
            for (DiscoveryNode discoNode : currentState.nodes()) {
                String markedTribeName = discoNode.getAttributes().get(TRIBE_NAME_SETTING.getKey());
                if (markedTribeName == null || !markedTribeName.equals(this.tribeName) || tribeState.nodes().get(discoNode.getId()) != null) continue;
                clusterStateChanged = true;
                TribeService.this.logger.info("[{}] removing node [{}]", (Object)this.tribeName, (Object)discoNode);
                nodes.remove(discoNode.getId());
            }
            for (DiscoveryNode tribe : tribeState.nodes()) {
                if (currentState.nodes().nodeExists(tribe)) continue;
                HashMap<String, String> tribeAttr = new HashMap<String, String>(tribe.getAttributes());
                tribeAttr.put(TRIBE_NAME_SETTING.getKey(), this.tribeName);
                DiscoveryNode discoNode = new DiscoveryNode(tribe.getName(), tribe.getId(), tribe.getEphemeralId(), tribe.getHostName(), tribe.getHostAddress(), tribe.getAddress(), Collections.unmodifiableMap(tribeAttr), tribe.getRoles(), tribe.getVersion());
                clusterStateChanged = true;
                TribeService.this.logger.info("[{}] adding node [{}]", (Object)this.tribeName, (Object)discoNode);
                nodes.remove(tribe.getId());
                nodes.add(discoNode);
            }
            if (clusterStateChanged) {
                newState.nodes(nodes);
            }
            return clusterStateChanged;
        }

        private boolean updateIndicesAndMetaData(ClusterState currentState, List<ClusterChangedEvent> tasks, ClusterState.Builder newState) {
            ClusterChangedEvent latestTask = tasks.get(tasks.size() - 1);
            ClusterState tribeState = latestTask.state();
            boolean clusterStateChanged = false;
            ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
            MetaData.Builder metaData = MetaData.builder(currentState.metaData());
            RoutingTable.Builder routingTable = RoutingTable.builder(currentState.routingTable());
            for (IndexMetaData index : currentState.metaData()) {
                String markedTribeName = TRIBE_NAME_SETTING.get(index.getSettings());
                if (markedTribeName == null || !markedTribeName.equals(this.tribeName)) continue;
                IndexMetaData tribeIndex = tribeState.metaData().index(index.getIndex());
                clusterStateChanged = true;
                if (tribeIndex == null || tribeIndex.getState() == IndexMetaData.State.CLOSE) {
                    TribeService.this.logger.info("[{}] removing index {}", (Object)this.tribeName, (Object)index.getIndex());
                    this.removeIndex(blocks, metaData, routingTable, index);
                    continue;
                }
                routingTable.add(tribeState.routingTable().index(index.getIndex()));
                Settings tribeSettings = Settings.builder().put(tribeIndex.getSettings()).put(TRIBE_NAME_SETTING.getKey(), this.tribeName).build();
                metaData.put(IndexMetaData.builder(tribeIndex).settings(tribeSettings));
            }
            for (IndexMetaData tribeIndex : tribeState.metaData()) {
                String preferredTribeName;
                IndexRoutingTable table = tribeState.routingTable().index(tribeIndex.getIndex());
                if (table == null) continue;
                String indexName = tribeIndex.getIndex().getName();
                IndexMetaData indexMetaData = currentState.metaData().index(indexName);
                if (indexMetaData == null) {
                    if (TribeService.this.droppedIndices.contains(indexName)) continue;
                    clusterStateChanged = true;
                    TribeService.this.logger.info("[{}] adding index {}", (Object)this.tribeName, (Object)tribeIndex.getIndex());
                    this.addNewIndex(tribeState, blocks, metaData, routingTable, tribeIndex);
                    continue;
                }
                String existingFromTribe = TRIBE_NAME_SETTING.get(indexMetaData.getSettings());
                if (this.tribeName.equals(existingFromTribe) || TribeService.ON_CONFLICT_ANY.equals(TribeService.this.onConflict)) continue;
                if (TribeService.ON_CONFLICT_DROP.equals(TribeService.this.onConflict)) {
                    clusterStateChanged = true;
                    TribeService.this.logger.info("[{}] dropping index {} due to conflict with [{}]", (Object)this.tribeName, (Object)tribeIndex.getIndex(), (Object)existingFromTribe);
                    this.removeIndex(blocks, metaData, routingTable, tribeIndex);
                    TribeService.this.droppedIndices.add(indexName);
                    continue;
                }
                if (!TribeService.this.onConflict.startsWith(TribeService.ON_CONFLICT_PREFER) || !this.tribeName.equals(preferredTribeName = TribeService.this.onConflict.substring(TribeService.ON_CONFLICT_PREFER.length()))) continue;
                clusterStateChanged = true;
                TribeService.this.logger.info("[{}] adding index {}, preferred over [{}]", (Object)this.tribeName, (Object)tribeIndex.getIndex(), (Object)existingFromTribe);
                this.removeIndex(blocks, metaData, routingTable, tribeIndex);
                this.addNewIndex(tribeState, blocks, metaData, routingTable, tribeIndex);
            }
            if (clusterStateChanged |= this.updateCustoms(currentState, tasks, metaData)) {
                newState.blocks(blocks);
                newState.metaData(metaData);
                newState.routingTable(routingTable.build());
            }
            return clusterStateChanged;
        }

        private boolean updateCustoms(ClusterState currentState, List<ClusterChangedEvent> tasks, MetaData.Builder metaData) {
            boolean clusterStateChanged = false;
            Set<String> changedCustomMetaDataTypeSet = tasks.stream().map(ClusterChangedEvent::changedCustomMetaDataSet).flatMap(Collection::stream).collect(Collectors.toSet());
            List tribeClientNodes = TribeService.this.nodes;
            Map<String, MetaData.Custom> mergedCustomMetaDataMap = TribeService.mergeChangedCustomMetaData(changedCustomMetaDataTypeSet, customMetaDataType -> tribeClientNodes.stream().map(x$0 -> TribeService.getClusterService(x$0)).map(ClusterService::state).map(ClusterState::metaData).map(clusterMetaData -> clusterMetaData.custom((String)customMetaDataType)).filter(custom1 -> custom1 != null && custom1 instanceof MergableCustomMetaData).map(custom2 -> (MergableCustomMetaData)((Object)TribeService.this.marshal(custom2))).collect(Collectors.toList()));
            for (String changedCustomMetaDataType : changedCustomMetaDataTypeSet) {
                MetaData.Custom mergedCustomMetaData = mergedCustomMetaDataMap.get(changedCustomMetaDataType);
                if (mergedCustomMetaData == null) {
                    if (!(currentState.metaData().custom(changedCustomMetaDataType) instanceof MergableCustomMetaData)) continue;
                    clusterStateChanged = true;
                    TribeService.this.logger.info("[{}] removing custom meta data type [{}]", (Object)this.tribeName, (Object)changedCustomMetaDataType);
                    metaData.removeCustom(changedCustomMetaDataType);
                    continue;
                }
                clusterStateChanged = true;
                TribeService.this.logger.info("[{}] updating custom meta data type [{}] data [{}]", (Object)this.tribeName, (Object)changedCustomMetaDataType, (Object)mergedCustomMetaData);
                metaData.putCustom(changedCustomMetaDataType, mergedCustomMetaData);
            }
            return clusterStateChanged;
        }

        private void removeIndex(ClusterBlocks.Builder blocks, MetaData.Builder metaData, RoutingTable.Builder routingTable, IndexMetaData index) {
            metaData.remove(index.getIndex().getName());
            routingTable.remove(index.getIndex().getName());
            blocks.removeIndexBlocks(index.getIndex().getName());
        }

        private void addNewIndex(ClusterState tribeState, ClusterBlocks.Builder blocks, MetaData.Builder metaData, RoutingTable.Builder routingTable, IndexMetaData tribeIndex) {
            Settings tribeSettings = Settings.builder().put(tribeIndex.getSettings()).put(TRIBE_NAME_SETTING.getKey(), this.tribeName).build();
            metaData.put(IndexMetaData.builder(tribeIndex).settings(tribeSettings));
            routingTable.add(tribeState.routingTable().index(tribeIndex.getIndex()));
            if (Regex.simpleMatch(TribeService.this.blockIndicesMetadata, tribeIndex.getIndex().getName())) {
                blocks.addIndexBlock(tribeIndex.getIndex().getName(), IndexMetaData.INDEX_METADATA_BLOCK);
            }
            if (Regex.simpleMatch(TribeService.this.blockIndicesRead, tribeIndex.getIndex().getName())) {
                blocks.addIndexBlock(tribeIndex.getIndex().getName(), IndexMetaData.INDEX_READ_BLOCK);
            }
            if (Regex.simpleMatch(TribeService.this.blockIndicesWrite, tribeIndex.getIndex().getName())) {
                blocks.addIndexBlock(tribeIndex.getIndex().getName(), IndexMetaData.INDEX_WRITE_BLOCK);
            }
        }
    }

    class TribeClusterStateListener
    implements ClusterStateListener {
        private final String tribeName;
        private final TribeNodeClusterStateTaskExecutor executor;

        TribeClusterStateListener(Node tribeNode) {
            String tribeName;
            this.tribeName = tribeName = TRIBE_NAME_SETTING.get(tribeNode.settings());
            this.executor = new TribeNodeClusterStateTaskExecutor(tribeName);
        }

        @Override
        public void clusterChanged(ClusterChangedEvent event) {
            TribeService.this.logger.debug("[{}] received cluster event, [{}]", (Object)this.tribeName, (Object)event.source());
            TribeService.this.clusterService.submitStateUpdateTask("cluster event from " + this.tribeName, event, ClusterStateTaskConfig.build(Priority.NORMAL), this.executor, (source, e) -> TribeService.this.logger.warn(() -> new ParameterizedMessage("failed to process [{}]", (Object)source), (Throwable)e));
        }
    }

    public static interface MergableCustomMetaData<T extends MetaData.Custom> {
        public T merge(T var1);
    }
}

