/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.BitMixer;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.Containers;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.HashOrderMixingStrategy;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.RandomizedHashOrderMixer;

public final class HashOrderMixing {
    public static final String PROPERTY_BIT_MIXER = "hppc.bitmixer";
    private static Strategy strategy;
    private static final HashOrderMixingStrategy DETERMINISTIC;

    private HashOrderMixing() {
    }

    public static HashOrderMixingStrategy randomized() {
        return RandomizedHashOrderMixer.INSTANCE;
    }

    public static HashOrderMixingStrategy constant(final long seed) {
        return new HashOrderMixingStrategy(){

            @Override
            public int newKeyMixer(int newContainerBufferSize) {
                return (int)BitMixer.mix64((long)newContainerBufferSize ^ seed);
            }

            @Override
            public HashOrderMixingStrategy clone() {
                return this;
            }
        };
    }

    @Deprecated
    public static HashOrderMixingStrategy deterministic() {
        return DETERMINISTIC;
    }

    @Deprecated
    public static HashOrderMixingStrategy none() {
        return new HashOrderMixingStrategy(){

            @Override
            public int newKeyMixer(int newContainerBufferSize) {
                return 0;
            }

            @Override
            public HashOrderMixingStrategy clone() {
                return this;
            }
        };
    }

    public static HashOrderMixingStrategy defaultStrategy() {
        if (strategy == null) {
            block7: {
                try {
                    String propValue = AccessController.doPrivileged(new PrivilegedAction<String>(){

                        @Override
                        public String run() {
                            return System.getProperty(HashOrderMixing.PROPERTY_BIT_MIXER);
                        }
                    });
                    if (propValue == null) break block7;
                    for (Strategy s : Strategy.values()) {
                        if (!s.name().equalsIgnoreCase(propValue)) continue;
                        strategy = s;
                        break;
                    }
                }
                catch (SecurityException e) {
                    Logger.getLogger(Containers.class.getName()).log(Level.INFO, "Failed to read 'tests.seed' property for initial random seed.", e);
                }
            }
            if (strategy == null) {
                strategy = Strategy.RANDOM;
            }
        }
        try {
            return (HashOrderMixingStrategy)strategy.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        DETERMINISTIC = new HashOrderMixingStrategy(){

            @Override
            public int newKeyMixer(int newContainerBufferSize) {
                return BitMixer.mix32(newContainerBufferSize);
            }

            @Override
            public HashOrderMixingStrategy clone() {
                return this;
            }
        };
    }

    public static enum Strategy implements Callable<HashOrderMixingStrategy>
    {
        RANDOM{

            @Override
            public HashOrderMixingStrategy call() {
                return HashOrderMixing.randomized();
            }
        }
        ,
        DETERMINISTIC{

            @Override
            public HashOrderMixingStrategy call() {
                return HashOrderMixing.deterministic();
            }
        }
        ,
        NONE{

            @Override
            public HashOrderMixingStrategy call() {
                return HashOrderMixing.none();
            }
        };

    }
}

