/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.document;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.Field;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.FieldType;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.SortedNumericDocValuesRangeQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValuesType;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;

public class NumericDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public NumericDocValuesField(String name, long value) {
        super(name, TYPE);
        this.fieldsData = value;
    }

    public static Query newRangeQuery(String field, long lowerValue, long upperValue) {
        return new SortedNumericDocValuesRangeQuery(field, lowerValue, upperValue){

            @Override
            SortedNumericDocValues getValues(LeafReader reader, String field) throws IOException {
                NumericDocValues values = reader.getNumericDocValues(field);
                if (values == null) {
                    return null;
                }
                return DocValues.singleton(values, reader.getDocsWithField(field));
            }
        };
    }

    public static Query newExactQuery(String field, long value) {
        return NumericDocValuesField.newRangeQuery(field, value, value);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.NUMERIC);
        TYPE.freeze();
    }
}

