/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexWriter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MergePolicy;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MergePolicyWrapper;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MergeTrigger;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SegmentCommitInfo;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SegmentInfos;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Version;

public class UpgradeIndexMergePolicy
extends MergePolicyWrapper {
    public UpgradeIndexMergePolicy(MergePolicy in) {
        super(in);
    }

    protected boolean shouldUpgradeSegment(SegmentCommitInfo si) {
        return !Version.LATEST.equals(si.info.getVersion());
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, IndexWriter writer) throws IOException {
        return this.in.findMerges(null, segmentInfos, writer);
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, IndexWriter writer) throws IOException {
        HashMap<SegmentCommitInfo, Boolean> oldSegments = new HashMap<SegmentCommitInfo, Boolean>();
        for (Object si : segmentInfos) {
            Boolean v = segmentsToMerge.get(si);
            if (v == null || !this.shouldUpgradeSegment((SegmentCommitInfo)si)) continue;
            oldSegments.put((SegmentCommitInfo)si, v);
        }
        if (this.verbose(writer)) {
            this.message("findForcedMerges: segmentsToUpgrade=" + oldSegments, writer);
        }
        if (oldSegments.isEmpty()) {
            return null;
        }
        MergePolicy.MergeSpecification spec = this.in.findForcedMerges(segmentInfos, maxSegmentCount, oldSegments, writer);
        if (spec != null) {
            for (MergePolicy.OneMerge om : spec.merges) {
                oldSegments.keySet().removeAll(om.segments);
            }
        }
        if (!oldSegments.isEmpty()) {
            if (this.verbose(writer)) {
                this.message("findForcedMerges: " + this.in.getClass().getSimpleName() + " does not want to merge all old segments, merge remaining ones into new segment: " + oldSegments, writer);
            }
            ArrayList<SegmentCommitInfo> newInfos = new ArrayList<SegmentCommitInfo>();
            for (SegmentCommitInfo si : segmentInfos) {
                if (!oldSegments.containsKey(si)) continue;
                newInfos.add(si);
            }
            if (spec == null) {
                spec = new MergePolicy.MergeSpecification();
            }
            spec.add(new MergePolicy.OneMerge(newInfos));
        }
        return spec;
    }

    private boolean verbose(IndexWriter writer) {
        return writer != null && writer.infoStream.isEnabled("UPGMP");
    }

    private void message(String message, IndexWriter writer) {
        writer.infoStream.message("UPGMP", message);
    }
}

